//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.digiwin.athena.esp.sdk;

import com.digiwin.athena.esp.sdk.constants.AppConstant;
import com.digiwin.athena.esp.sdk.model.MessageModel;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.athena.esp.sdk.util.ArrayUtil;
import com.digiwin.athena.esp.sdk.util.HttpInvokeUtil;
import com.jugg.agile.biz.digiwin.esp.DwEspSdkHook;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

abstract class AbstractInvoker {
    AbstractInvoker() {
    }

    static {
        System.out.println("AbstractInvoker init");
        JaLog.info("AbstractInvoker init");
    }

    protected abstract String getTargetUrl(MessageModel var1);

    protected abstract Map<String, Object> getRequestHeaders(RequestModel var1) throws Exception;

    protected abstract Map<String, Object> getResponseHeaders(HttpResponse var1, RequestModel var2);

    protected abstract void saveRequestLog(String var1, Map<String, Object> var2, Map<String, Object> var3, String var4) throws ClientProtocolException, IOException;

    protected abstract void saveResponseLog(String var1, Map<String, Object> var2, Integer var3, Map<String, Object> var4, String var5) throws ClientProtocolException, IOException;

    protected abstract void saveResponseErrorLog(String var1, Map<String, Object> var2, Exception var3) throws ClientProtocolException, IOException;

    protected void execute(MessageModel messageModel) throws Exception {
        String tTargetUrl = this.getTargetUrl(messageModel);
        HttpPost tHttpPost = new HttpPost(tTargetUrl);
        DwEspSdkHook.RequestHook.apply(tHttpPost);
        Map<String, Object> reqHeaders = this.getRequestHeaders(messageModel.getRequestModel());
        Set<String> tKeySet = reqHeaders.keySet();
        Iterator var6 = tKeySet.iterator();

        while (var6.hasNext()) {
            String tKey = (String) var6.next();
            if (reqHeaders.get(tKey) != null) {
                tHttpPost.setHeader(tKey, reqHeaders.get(tKey).toString());
            }
        }

        if ("standard".equals(messageModel.getInvokeProductType())) {
            tHttpPost.removeHeaders("digi-middleware-auth-app");
            tHttpPost.removeHeaders("digi-middleware-auth-app-secret");
        } else if (ArrayUtil.containsIngoreCase(AppConstant.APP_AUTH_EXCLUDE, messageModel.getRequestModel().getServiceProd().trim())) {
            tHttpPost.removeHeaders("digi-middleware-auth-app");
            tHttpPost.removeHeaders("digi-middleware-auth-app-secret");
        }

        StringEntity tStringEntity = new StringEntity(messageModel.getRequestModel().getBodyJsonString(), ContentType.APPLICATION_JSON);
        tHttpPost.setEntity(tStringEntity);
        this.saveRequestLog(messageModel.getRequestModel().getTenantId(), reqHeaders, reqHeaders, messageModel.getRequestModel().getBodyJsonString());

        try {
            HttpResponse tHttpResponse = HttpInvokeUtil.executeHttp(tHttpPost, messageModel.getRequestModel().isIdempotency());
            Integer tHttpStatus = tHttpResponse.getStatusLine().getStatusCode();
            Map<String, Object> resHeaders = this.getResponseHeaders(tHttpResponse, messageModel.getRequestModel());
            ResponseModel tResponseModel = new ResponseModel(resHeaders, EntityUtils.toString(tHttpResponse.getEntity()));
            this.saveResponseLog(messageModel.getRequestModel().getTenantId(), reqHeaders, tHttpStatus, resHeaders, tResponseModel.getBodyJsonString());
            messageModel.setResponseModel(tResponseModel);


        } catch (Exception var11) {
            this.saveResponseErrorLog(messageModel.getRequestModel().getTenantId(), reqHeaders, var11);
            var11.printStackTrace();
            throw var11;
        } finally {
        }
    }
}
