package com.jugg.agile.biz.digiwin.dapper;

import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaPostPropertyHandler;
import com.jugg.agile.framework.core.dapper.alarm.JaAlarm;
import com.jugg.agile.framework.core.dapper.alarm.JaNotify;
import com.jugg.agile.framework.core.dapper.alarm.adapter.feishu.JaFeiShuAlarm;
import com.jugg.agile.framework.core.dapper.log.logback.JaLogbackFilter;

public class DwJaDapperPropertyHandler implements JaPostPropertyHandler {
    @Override
    public void addAndCover() {
        if (JaEnvProperty.isCD()) {
            JaAlarm.setAlarmHandler(new JaFeiShuAlarm("default")::alarm);
            JaAlarm.setThrowableHandler(new JaFeiShuAlarm("throwable")::alarm);
            JaNotify.setNotifyHandler(new JaFeiShuAlarm("notify.default")::alarm);


            JaLogbackFilter.getInfoDenyLoggerNamePreSet().add("com.ctrip.framework.apollo");
            JaLogbackFilter.getInfoDenyLoggerNamePreSet().add("com.digiwin.loadbalance");
        }
    }

    @Override
    public int order() {
        return 100;
    }

    public static void main(String[] args) {
        new JaFeiShuAlarm("notify.default").alarm("test ok http");
    }
}
