/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.esp.sdk.constants.AppConstant;
import com.digiwin.athena.esp.sdk.model.MessageModel;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.athena.esp.sdk.util.ArrayUtil;
import com.digiwin.athena.esp.sdk.util.HttpInvokeUtil;
import com.jugg.agile.biz.digiwin.esp.EspSdkHook;
import com.jugg.agile.biz.digiwin.esp.meta.dto.EspBody;
import com.jugg.agile.framework.core.dapper.JaDapper;
import com.jugg.agile.framework.core.dapper.meta.NodeKind;
import com.jugg.agile.framework.core.dapper.meta.NodeSpan;
import com.jugg.agile.framework.core.meta.JaReturn2;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

abstract class AbstractInvoker {
    private static final NodeKind Esp = new NodeKind("esp");

    AbstractInvoker() {
    }

    protected abstract String getTargetUrl(MessageModel var1);

    protected abstract Map<String, Object> getRequestHeaders(RequestModel var1) throws Exception;

    protected abstract Map<String, Object> getResponseHeaders(HttpResponse var1, RequestModel var2);

    protected abstract void saveRequestLog(String var1, Map<String, Object> var2, Map<String, Object> var3, String var4) throws ClientProtocolException, IOException;

    protected abstract void saveResponseLog(String var1, Map<String, Object> var2, Integer var3, Map<String, Object> var4, String var5) throws ClientProtocolException, IOException;

    protected abstract void saveResponseErrorLog(String var1, Map<String, Object> var2, Exception var3) throws ClientProtocolException, IOException;

    protected void execute(MessageModel messageModel) throws Throwable {
        String tTargetUrl = this.getTargetUrl(messageModel);
        StringEntity tStringEntity = new StringEntity(messageModel.getRequestModel().getBodyJsonString(), ContentType.APPLICATION_JSON);
        NodeSpan nodeSpan = NodeSpan.builder().id(tTargetUrl).nodeKind(Esp).build();
        JaDapper.dapper((NodeSpan)nodeSpan, (Object[])new Object[]{tStringEntity}, () -> this.executeOld(messageModel, tTargetUrl, tStringEntity));
    }

    protected String executeOld(MessageModel messageModel, String tTargetUrl, StringEntity tStringEntity) throws Exception {
        HttpPost tHttpPost = new HttpPost(tTargetUrl);
        EspSdkHook.RequestHook.apply((Object)tHttpPost);
        Map<String, Object> reqHeaders = this.getRequestHeaders(messageModel.getRequestModel());
        Set<String> tKeySet = reqHeaders.keySet();
        for (String tKey : tKeySet) {
            if (reqHeaders.get(tKey) == null) continue;
            tHttpPost.setHeader(tKey, reqHeaders.get(tKey).toString());
        }
        if ("standard".equals(messageModel.getInvokeProductType()) || ArrayUtil.containsIngoreCase((String[])AppConstant.APP_AUTH_EXCLUDE, (String)messageModel.getRequestModel().getServiceProd().trim())) {
            tHttpPost.removeHeaders("digi-middleware-auth-app");
            tHttpPost.removeHeaders("digi-middleware-auth-app-secret");
        }
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        this.saveRequestLog(messageModel.getRequestModel().getTenantId(), reqHeaders, reqHeaders, messageModel.getRequestModel().getBodyJsonString());
        try {
            HttpResponse tHttpResponse = HttpInvokeUtil.executeHttp((HttpUriRequest)tHttpPost, (boolean)messageModel.getRequestModel().isIdempotency());
            Integer tHttpStatus = tHttpResponse.getStatusLine().getStatusCode();
            Map<String, Object> resHeaders = this.getResponseHeaders(tHttpResponse, messageModel.getRequestModel());
            String resp = EntityUtils.toString((HttpEntity)tHttpResponse.getEntity());
            ResponseModel tResponseModel = new ResponseModel(resHeaders, resp);
            messageModel.setResponseModel(tResponseModel);
            EspBody espBody = (EspBody)JSON.parseObject((String)resp, EspBody.class);
            espBody.setTenantId(messageModel.getRequestModel().getTenantId());
            EspSdkHook.ResponseHook.apply((Object)new JaReturn2((Object)tHttpResponse, (Object)espBody));
            return resp;
        }
        catch (Throwable var11) {
            EspSdkHook.ThrowableHook.apply((Object)new JaReturn2((Object)var11, (Object)messageModel));
            throw var11;
        }
    }
}

