/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.biz.digiwin.esp;

import com.digiwin.athena.esp.sdk.exception.InvocationException;
import com.digiwin.athena.esp.sdk.model.MessageModel;
import com.jugg.agile.biz.digiwin.esp.EspAlarm;
import com.jugg.agile.biz.digiwin.esp.meta.dto.EspBody;
import com.jugg.agile.biz.digiwin.esp.meta.dto.EspExecution;
import com.jugg.agile.biz.digiwin.esp.meta.message.EspAlarmMessage;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.context.JaMapContextChain;
import com.jugg.agile.framework.core.meta.JaReturn2;
import com.jugg.agile.framework.core.meta.function.JaFunctionP;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;

public class EspSdkHook {
    public static final JaFunctionP<HttpPost> RequestHook = httpPost -> JaMapContextChain.getInstance().transmit().forEach((arg_0, arg_1) -> ((HttpPost)httpPost).addHeader(arg_0, arg_1));
    public static final JaFunctionP<JaReturn2<HttpResponse, EspBody>> ResponseHook = args -> {
        EspBody espBody = (EspBody)args.getR2();
        EspExecution execution = espBody.getStd_data().getExecution();
        String code = execution.getCode();
        if (!"0".equals(code)) {
            String appId = JaEnvProperty.getApplicationName();
            if ("-1".equals(code)) {
                code = "P." + appId + ".9999.9999";
            }
            EspAlarmMessage exceptionMQMessage = new EspAlarmMessage();
            exceptionMQMessage.setErrorCode(code);
            exceptionMQMessage.setException(execution.getDescription());
            exceptionMQMessage.setTenantId(espBody.getTenantId());
            EspAlarm.alarm(exceptionMQMessage);
        }
    };
    public static final JaFunctionP<JaReturn2<Throwable, MessageModel>> ThrowableHook = args -> {
        Throwable throwable = (Throwable)args.getR1();
        MessageModel messageModel = (MessageModel)args.getR2();
        if (throwable instanceof InvocationException) {
            InvocationException invocationException = (InvocationException)throwable;
            EspAlarmMessage exceptionMQMessage = new EspAlarmMessage();
            exceptionMQMessage.setErrorCode(invocationException.getErrorCode());
            exceptionMQMessage.setException(invocationException.getErrorMessage());
            exceptionMQMessage.setTenantId(messageModel.getRequestModel().getTenantId());
            EspAlarm.alarm(exceptionMQMessage);
        }
    };

    private EspSdkHook() {
    }
}

