/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.biz.digiwin.config;

import com.jugg.agile.biz.digiwin.util.DwNacosUtil;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaPrePropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.processor.JaPropertiesProcessor;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;

public class DwNacosConfigPropertyHandler
implements JaPrePropertyHandler {
    public void addAndCover() {
        if (DwNacosUtil.isExistsJaNacosConfigService()) {
            this.load();
        }
    }

    private void load() {
        try {
            String serverAddr = JaProperty.get((String)"ja.nacos.serverAddr");
            if (JaStringUtil.isSafeEmpty((String)serverAddr)) {
                Properties properties = JaPropertiesProcessor.readByResources((String)String.format("nacos/%s.properties", JaEnvProperty.getEnv()));
                if (null != properties) {
                    properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(o, o2) -> JaProperty.getPropertyMap().put(o.toString(), o2)));
                } else {
                    JaLog.warn((String)"DwNacosConfigPropertyHandler load empty", (Object[])new Object[0]);
                }
            }
        }
        catch (Throwable e) {
            JaLog.error((String)"DwNacosConfigPropertyHandler init error", (Object[])new Object[]{e});
        }
    }

    public int order() {
        return -10;
    }

    public static void main(String[] args) {
        JaEnvProperty.getEntity().setEnv("aliyun-paas");
        DwNacosConfigPropertyHandler jaNacosConfigNameSpacePropertyHandler = new DwNacosConfigPropertyHandler();
        jaNacosConfigNameSpacePropertyHandler.load();
        Map propertyMap = JaProperty.getPropertyMap();
        System.out.println();
    }
}

