/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.biz.digiwin.esp;

import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.io.file.JaFileReadUtil;
import com.jugg.agile.framework.core.util.reflect.clazz.loader.JaAppClassLoader;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class EspSdkJavaCompiler {
    public static void test() {
        try {
            String sourceCode = JaFileReadUtil.readAsString((String)"sourceCode/AbstractInvoker.txt");
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
            File outDir = new File("out");
            outDir.mkdir();
            List<File> files = Collections.singletonList(outDir);
            fileManager.setLocation(StandardLocation.CLASS_OUTPUT, files);
            String className = "com.digiwin.athena.esp.sdk.AbstractInvoker";
            InMemoryJavaFileObject javaFileObject = new InMemoryJavaFileObject(className, sourceCode);
            List<InMemoryJavaFileObject> compilationUnits = Collections.singletonList(javaFileObject);
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, null, null, null, compilationUnits);
            if (Boolean.TRUE.equals(task.call())) {
                System.out.println("Compilation successful.");
                byte[] classBytes = Files.readAllBytes(outDir.toPath().resolve("com.digiwin.athena.esp.sdk".replace(".", "/") + "/AbstractInvoker.class"));
                Class clazz = JaAppClassLoader.defineClass((String)className, (byte[])classBytes);
            } else {
                System.out.println("Compilation failed.");
            }
        }
        catch (Throwable e) {
            JaLog.error((String)"compiler error", (Object[])new Object[]{e});
        }
    }

    public static void main(String[] args) {
        System.out.println(JaFileReadUtil.readAsString((String)"sourceCode/AbstractInvoker.txt"));
        EspSdkJavaCompiler.test();
    }

    static class InMemoryJavaFileObject
    extends SimpleJavaFileObject {
        final String code;

        InMemoryJavaFileObject(String name, String code) {
            super(URI.create("string:///" + name.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.code = code;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.code;
        }
    }
}

