/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.biz.digiwin.config;

import com.jugg.agile.framework.core.config.JaEnvPropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.JaStringUtil;
import java.util.Set;

public class DwPrivateDeploymentPropertyHandler
implements JaEnvPropertyHandler {
    private static final boolean isLocal = "local".equalsIgnoreCase(System.getenv().get("deploy_cloud"));

    public void addAndCover() {
        if (isLocal) {
            this.wrapNacosDiscovery();
            this.wrapMysql();
            this.wrapMongodb();
        }
    }

    public int order() {
        return 10;
    }

    public static boolean getIsLocal() {
        return isLocal;
    }

    private void wrapNacosDiscovery() {
        JaProperty.getPropertyMap().put("dwdiscoveryServer", System.getenv().get("spring.cloud.nacos.discovery.server-addr"));
    }

    private void wrapMysql() {
        String host = System.getenv().get("custom.datasource.host");
        if (JaStringUtil.isSafeEmpty((String)host)) {
            return;
        }
        String port = System.getenv().get("custom.datasource.port");
        String database = System.getenv().get("custom.datasource.database");
        String type = System.getenv().get("custom.datasource.type");
        String args = System.getenv().get("custom.datasource.args");
        String jdbcUrl = String.format("jdbc:%s://%s:%s/%s?useUnicode=true&allowMultiQueries=true&characterEncoding=UTF-8&serverTimezone=Asia/Shanghai&autoReconnect=true&%s", type, host, port, database, args);
        Set keys = JaProperty.getPropertyMap().keySet();
        keys.forEach(key -> {
            if (key.startsWith("spring.datasource.") && key.endsWith(".url")) {
                JaProperty.getPropertyMap().put(key, jdbcUrl);
            }
        });
    }

    private void wrapMongodb() {
        String cluster = System.getenv().get("custom.data.mongodb.cluster");
        if (JaStringUtil.isSafeEmpty((String)cluster)) {
            return;
        }
        String database = System.getenv().get("spring.data.mongodb.database");
        String username = System.getenv().get("spring.data.mongodb.username");
        String password = System.getenv().get("spring.data.mongodb.password");
        String mongoUri = String.format("mongodb://%s:%s@%s", username, password, cluster);
        Set keys = JaProperty.getPropertyMap().keySet();
        keys.forEach(key -> {
            if (key.startsWith("spring.data.") && key.contains("mongodb")) {
                if (key.endsWith(".uri")) {
                    JaProperty.getPropertyMap().put(key, mongoUri);
                } else if (key.endsWith(".database")) {
                    JaProperty.getPropertyMap().put(key, database);
                }
            }
        });
    }
}

