package com.jugg.agile.biz.digiwin.config;

import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaEnvPropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.JaStringUtil;

import java.util.Map;

/**
 * 环境变量加载
 *
 * @author chenjian
 * @since 2024年08月02日 09:58:31
 */
public class DwEnvPropertyHandler implements JaEnvPropertyHandler {
    @Override
    public void addAndCover() {
        String imageEnv = initImageEnv();
        if (null != imageEnv) {
            Map<String, String> envMap = System.getenv();
            JaProperty.getPropertyMap().putAll(envMap);
            JaEnvProperty.Entity entity = JaEnvProperty.getEntity();
            entity.setImageEnv(imageEnv);
            // 地端部署 也会写入 linux os
            // TODO 新版地端部署 可能会变; 有可能地端部署会获取不到这些值
            entity.setImageVersion(System.getenv().get("VERSION"));
            entity.setImageName(System.getenv().get("APPIMAGENAME"));
            entity.setCdVersion(System.getenv().get("SMALLVERSION"));
            entity.setCdName(System.getenv().get("APPID"));
            entity.setPodName(System.getenv().get("HOSTNAME"));
        }
    }

    @Override
    public int order() {
        return -10;
    }

    private static String initImageEnv() {
        String cdmCloud = System.getenv().get("CDMCLOUD");
        if (JaStringUtil.isSafeNotEmpty(cdmCloud)) {
            String cdmArea = System.getenv().get("CDMAREA");
            if (JaStringUtil.isSafeNotEmpty(cdmArea)) {
                return cdmCloud.trim().toLowerCase() + "-" + cdmArea.trim().toLowerCase();
            }
        }
        return null;
    }
}
