package com.jugg.agile.biz.digiwin.config;

import com.jugg.agile.framework.core.config.JaEnvPropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.JaStringUtil;

import java.util.Set;

/**
 * 私有化部署适配
 * TODO 待定, 是否适配整个智驱, 原因 : 多rds, 多mongo是否配置统一???
 * https://docs.qq.com/sheet/DSk1ZTnBFWUNhRGJD?tab=BB08J2
 *
 * @author chenjian
 * @since 2024年09月02日 09:58:31
 */
public class DwPrivateDeploymentPropertyHandler implements JaEnvPropertyHandler {
    /**
     * 私有化环境部署标示
     */
    private static final boolean isLocal;

    static {
        isLocal = "local".equalsIgnoreCase(System.getenv().get("deploy_cloud"));
    }


    @Override
    public void addAndCover() {
        if (isLocal) {
            wrapNacosDiscovery();
            wrapMysql();
            wrapMongodb();
        }
    }

    @Override
    public int order() {
        return 10;
    }

    public static boolean getIsLocal() {
        return isLocal;
    }

    private void wrapNacosDiscovery() {
        JaProperty.getPropertyMap().put("dwdiscoveryServer", System.getenv().get("spring.cloud.nacos.discovery.server-addr"));
    }

    private void wrapMysql() {
        String host = System.getenv().get("custom.datasource.host");
        if (JaStringUtil.isSafeEmpty(host)) {
            return;
        }

        String port = System.getenv().get("custom.datasource.port");
        String database = System.getenv().get("custom.datasource.database");
        // mariadb
        String type = System.getenv().get("custom.datasource.type");
        String args = System.getenv().get("custom.datasource.args");

        // jdbc:mariadb://ip:port/database?useUnicode=true&allowMultiQueries=true&characterEncoding=UTF-8&serverTimezone=Asia/Shanghai

        // jdbc:mariadb://ip:port/database?useUnicode=true&allowMultiQueries=true&characterEncoding=UTF-8&serverTimezone=Asia/Shanghai&autoReconnect=true
        // &autoReconnect=true&useSSL=false&tinyInt1isBit=false&failOverReadOnly=false&zeroDateTimeBehavior=convertToNull

        String jdbcUrl = String.format("jdbc:%s://%s:%s/%s?useUnicode=true&allowMultiQueries=true&characterEncoding=UTF-8&serverTimezone=Asia/Shanghai&autoReconnect=true&%s"
                , type
                , host
                , port
                , database
                , args
        );

        Set<String> keys = JaProperty.getPropertyMap().keySet();
        keys.forEach(key -> {
            if (key.startsWith("spring.datasource.") && key.endsWith(".url")) {
                JaProperty.getPropertyMap().put(key, jdbcUrl);
            }
        });
    }

    private void wrapMongodb() {
        String cluster = System.getenv().get("custom.data.mongodb.cluster");
        if (JaStringUtil.isSafeEmpty(cluster)) {
            return;
        }
        String database = System.getenv().get("spring.data.mongodb.database");
        String username = System.getenv().get("spring.data.mongodb.username");
        String password = System.getenv().get("spring.data.mongodb.password");
        // mongodb+srv://<db_username>:<db_password>@<clusterName>.mongodb.net/?retryWrites=true&w=majority
        String mongoUri = String.format("mongodb://%s:%s@%s"
                , username
                , password
                , cluster
        );

        Set<String> keys = JaProperty.getPropertyMap().keySet();
        keys.forEach(key -> {
            if (key.startsWith("spring.data.") && key.contains("mongodb")) {
                if (key.endsWith(".uri")) {
                    JaProperty.getPropertyMap().put(key, mongoUri);
                } else if (key.endsWith(".database")) {
                    JaProperty.getPropertyMap().put(key, database);
                }
            }
        });
    }

}
