package com.jugg.agile.biz.digiwin.config;

import com.jugg.agile.biz.digiwin.util.DwNacosUtil;
import com.jugg.agile.framework.core.config.JaCenterPropertyHandler;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigPropertiesProcessor;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigService;

/**
 * Apollo 配置
 *
 * @author gengwei
 * @since 2024/8/7 11:28
 */
public class DwApolloPropertyHandler implements JaCenterPropertyHandler {

    @Override
    public void addAndCover() {
        try {
            if (DwNacosUtil.isExistsJaNacosConfigService()) {
                JaProperty.getPropertyMap().put("app.id", JaEnvProperty.getApplicationName());
                JaNacosConfigService.loadYaml("apollo.yml", JaNacosConfigPropertiesProcessor.getNameSpaceCommon());
            }
        } catch (Throwable e) {
            JaLog.error("apollo nacos read error", e);
        }

    }

    @Override
    public int order() {
        return 10;
    }
}
