package com.jugg.agile.biz.digiwin.esp;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.esp.sdk.model.MqPublishParam;
import com.digiwin.athena.esp.sdk.mq.RabbitMqManager;
import com.jugg.agile.biz.digiwin.esp.meta.message.EspAlarmMessage;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import com.jugg.agile.framework.core.util.concurrent.JaThreadPool;

public class EspAlarm {

    /**
     * 发送异常信息到mq供告警平台处理
     * TODO 偶尔了esp业务 又单独创建了RabbitMq
     */
    public static void alarm(String errorCode,String exception,String tenantId) {
        JaThreadPool.execute(() -> {
            try {
                EspAlarmMessage exceptionMQMessage = new EspAlarmMessage();
                exceptionMQMessage.setErrorCode(errorCode);
                exceptionMQMessage.setException(exception);
                exceptionMQMessage.setTenantId(tenantId);
                exceptionMQMessage.setAppId(JaEnvProperty.getApplicationName());
                exceptionMQMessage.setPinpointId(JaMDC.get());
                RabbitMqManager mqManager = RabbitMqManager.getRabbitMQManager();
                MqPublishParam publishParam = new MqPublishParam();
                publishParam.setExchangeName("it.sys.exchange");
                publishParam.setExchangeType("direct");
                publishParam.setQueueName("it_sys_error");
                publishParam.setRoutingKey("mon.error");
                publishParam.setMessage(JSON.toJSONString(exceptionMQMessage));
                mqManager.publishMessage(publishParam);
            } catch (Throwable e) {
                JaLog.error("push exceptionMessage to MQ fail.", e);
            }
        });
    }
}
