/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.init;

import ch.qos.logback.classic.LoggerContext;
import com.digiwin.athena.esp.sdk.constants.AppConstant;
import com.digiwin.athena.esp.sdk.constants.DAPConstant;
import com.digiwin.athena.esp.sdk.constants.ParamConstant;
import com.digiwin.athena.esp.sdk.constants.URLConstant;
import com.digiwin.athena.esp.sdk.parameter.ApplicationParameter;
import com.digiwin.athena.esp.sdk.util.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EspSdkInitialize {
    private static Log log = LogFactory.getLog(EspSdkInitialize.class);

    public static void initMQConfig(String mqUrl) {
        URLConstant.MQ_URL = mqUrl.trim();
    }

    public static void initAppConfig(String appid, String apptoken) {
        AppConstant.APP_ID = appid.trim();
        AppConstant.APP_TOKEN = apptoken.trim();
    }

    public static void initAppSecret(String appsecret) {
        AppConstant.APP_SECRET = appsecret.trim();
    }

    public static void setAppAuthExclude(String authExclude) {
        if (!StringUtil.isEmptyOrSpace((Object)authExclude)) {
            AppConstant.APP_AUTH_EXCLUDE = authExclude.split(",");
        }
    }

    public static void initLmcConfig(String lmcUrl) {
        if (lmcUrl != null) {
            URLConstant.LMC_BASE_URL = lmcUrl.trim().startsWith("http") ? lmcUrl.trim() : "http://" + lmcUrl.trim();
        }
    }

    public static void enableEspRouting(Boolean value) {
        ApplicationParameter.setParameter((String)"enableEspRouting", (Object)value);
    }

    public static void initConfig(String espDomain, String mdcDomain) {
        EspSdkInitialize.initConfig(espDomain, mdcDomain, null, null, null);
    }

    public static void initConfig(String espDomain, String mdcDomain, String kmDomain) {
        EspSdkInitialize.initConfig(espDomain, mdcDomain, kmDomain, null, null);
    }

    public static void initConfig(String espDomain, String mdcDomain, String kmDomain, String eocDomain) {
        EspSdkInitialize.initConfig(espDomain, mdcDomain, kmDomain, eocDomain, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initConfig(String espDomain, String mdcDomain, String kmDomain, String eocDomain, String iamDomain) {
        Class<EspSdkInitialize> var5 = EspSdkInitialize.class;
        Class<EspSdkInitialize> clazz = EspSdkInitialize.class;
        synchronized (EspSdkInitialize.class) {
            if (espDomain != null) {
                if (espDomain.trim().startsWith("http")) {
                    URLConstant.ESP_REST_BASE_URL = espDomain.trim() + "/CROSS/RESTful";
                    URLConstant.ESPDP_BASE_URL = espDomain.trim().replaceFirst("esp", "espdp");
                } else {
                    URLConstant.ESP_REST_BASE_URL = "http://" + espDomain.trim() + "/CROSS/RESTful";
                    URLConstant.ESPDP_BASE_URL = "http://" + espDomain.trim().replaceFirst("esp", "espdp");
                }
            }
            if (mdcDomain != null) {
                URLConstant.MDC_BASE_URL = mdcDomain.trim().startsWith("http") ? mdcDomain.trim() : "http://" + mdcDomain.trim();
            }
            if (kmDomain != null) {
                URLConstant.TM_BASE_URL = kmDomain.trim().startsWith("http") ? kmDomain.trim() : "http://" + kmDomain.trim();
            }
            if (eocDomain != null) {
                URLConstant.EOC_BASE_URL = eocDomain.trim().startsWith("http") ? eocDomain.trim() : "http://" + eocDomain.trim();
            }
            if (iamDomain != null) {
                URLConstant.IAM_BASE_URL = iamDomain.trim().startsWith("http") ? iamDomain.trim() : "http://" + iamDomain.trim();
            }
            EspSdkInitialize.initLoadbalanceReouteConfig();
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    private static void initLogger() {
        LoggerContext loggerContext = null;
        try {
            ClassLoader classLoader = EspSdkInitialize.deduceClassLoader();
            if (classLoader != null) {
                Class<?> dwLoggerContextClazz = classLoader.loadClass("com.digiwin.app.log.DWLoggerContext");
                Method targetMethod = dwLoggerContextClazz.getDeclaredMethod("getContext", new Class[0]);
                loggerContext = (LoggerContext)targetMethod.invoke(null, new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException var4) {
            log.error((Object)"EspSdkInitialize.initLogger failed!", (Throwable)var4);
        }
    }

    private static ClassLoader deduceClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = EspSdkInitialize.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    public static void initHttpParamConfig(Integer maxTotal, Integer defaultMaxPerroute, Integer connectTimeOut) {
        ParamConstant.CONNECT_TIME_OUT = connectTimeOut;
        ParamConstant.DEFAULT_MAX_PERROUTE = defaultMaxPerroute;
        ParamConstant.MAX_TOTAL = maxTotal;
    }

    public static void initRetryParamConfig(Integer retryCount, Long retryInterval) {
        ParamConstant.RETRY_COUNT = retryCount;
        ParamConstant.RETRY_INTERVAL = retryInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initLoadbalanceReouteConfig() {
        Class<EspSdkInitialize> var0 = EspSdkInitialize.class;
        Class<EspSdkInitialize> clazz = EspSdkInitialize.class;
        synchronized (EspSdkInitialize.class) {
            block10: {
                if (!DAPConstant.INITED) {
                    DAPConstant.INITED = true;
                    try {
                        ClassLoader classLoader = EspSdkInitialize.deduceClassLoader();
                        if (classLoader == null) break block10;
                        Class<?> espLoadBalanceUtilaClass = classLoader.loadClass("com.digiwin.loadbalance.esp.ESPLoadBalanceUtil");
                        DAPConstant.LOADBALANCE_ENABLE = true;
                        try {
                            espLoadBalanceUtilaClass.getField("EAI_ID_SERACH_SERVICE_NAME_KEY");
                        }
                        catch (NoSuchFieldException var6) {
                            DAPConstant.LOADBALANCE_ENABLE = false;
                        }
                        DAPConstant.SUPPORT_REROUTE = true;
                        try {
                            espLoadBalanceUtilaClass.getField("dwMainExecWrapper");
                        }
                        catch (NoSuchFieldException var5) {
                            DAPConstant.SUPPORT_REROUTE = false;
                        }
                    }
                    catch (ClassNotFoundException var7) {
                        DAPConstant.LOADBALANCE_ENABLE = false;
                        DAPConstant.SUPPORT_REROUTE = false;
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

