/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.biz.digiwin.config.post;

import com.jugg.agile.biz.digiwin.config.env.DwEnvPropertyHandler;
import com.jugg.agile.framework.core.config.JaPostPropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.JaStringUtil;
import java.util.Set;

public class DwPrivateDeploymentPostPropertyHandler
implements JaPostPropertyHandler {
    public void addAndCover() {
        if (DwEnvPropertyHandler.getIsLocal()) {
            this.wrapNacosDiscovery();
            this.wrapMysql();
            this.wrapDomain();
        }
    }

    public int order() {
        return 10;
    }

    private void wrapNacosDiscovery() {
        JaProperty.getPropertyMap().put("dwdiscoveryServer", System.getenv().get("spring.cloud.nacos.discovery.server-addr"));
    }

    private void wrapMysql() {
        String host = System.getenv().get("custom.datasource.host");
        if (JaStringUtil.isSafeEmpty((String)host)) {
            return;
        }
        String port = System.getenv().get("custom.datasource.port");
        String database = System.getenv().get("custom.datasource.database");
        String type = System.getenv().get("custom.datasource.type");
        String args = System.getenv().get("custom.datasource.args");
        String jdbcUrl = String.format("jdbc:%s://%s:%s/%s?useUnicode=true&allowMultiQueries=true&characterEncoding=UTF-8&serverTimezone=Asia/Shanghai&autoReconnect=true&%s", type, host, port, database, args);
        Set keys = JaProperty.getPropertyMap().keySet();
        keys.forEach(key -> {
            if (key.startsWith("spring.datasource.") && key.endsWith(".url")) {
                JaProperty.getPropertyMap().put(key, jdbcUrl);
                JaProperty.getPropertyMap().put("spring.datasource.driver-class-name", System.getenv().get("spring.datasource.driver-class-name"));
            }
            if (key.startsWith("ja.datasource.pool.")) {
                // empty if block
            }
        });
    }

    private void wrapDomain() {
        String domainLocal = System.getenv().get("custom.domain");
        if (JaStringUtil.isSafeEmpty((String)domainLocal)) {
            return;
        }
        String domainCNA = "apps.digiwincloud.com.cn";
        String domainCNB = "digiwincloud.com.cn";
        String domainTWA = "apps.digiwincloud.com";
        String domainTWB = "digiwincloud.com";
        String domainYunA = "digiwincloudlocal.com.cn";
        String domainYunB = "digiwincloudlocal.com";
        JaProperty.getPropertyMap().forEach((k, v) -> {
            String value = v.toString();
            String replaceDomain = null;
            if (value.startsWith("https://")) {
                if (value.contains(domainCNA)) {
                    replaceDomain = domainCNA;
                } else if (value.contains(domainCNB)) {
                    replaceDomain = domainCNB;
                } else if (value.contains(domainTWA)) {
                    replaceDomain = domainTWA;
                } else if (value.contains(domainTWB)) {
                    replaceDomain = domainTWB;
                } else if (value.contains(domainYunA)) {
                    replaceDomain = domainYunA;
                } else if (value.contains(domainYunB)) {
                    replaceDomain = domainYunB;
                }
                if (null != replaceDomain) {
                    JaProperty.getPropertyMap().put(k, value.replace("https", "http").replace(replaceDomain, domainLocal));
                }
            }
        });
    }
}

