package com.jugg.agile.biz.digiwin.config.post;

import com.jugg.agile.biz.digiwin.config.env.DwEnvPropertyHandler;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaPostPropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.alarm.JaAlarm;
import com.jugg.agile.framework.core.dapper.alarm.JaNotify;
import com.jugg.agile.framework.core.dapper.alarm.adapter.feishu.JaFeiShuAlarm;
import com.jugg.agile.framework.core.dapper.alarm.adapter.qywx.JaQyWxAlarm;

public class DwJaDapperPropertyHandler implements JaPostPropertyHandler {
    @Override
    public void addAndCover() {
        if (JaEnvProperty.isCD() && !DwEnvPropertyHandler.getIsLocal()) {
            JaAlarm.setAlarmHandler(new JaQyWxAlarm("default")::alarm);
            JaAlarm.setThrowableHandler(new JaQyWxAlarm("throwable")::alarm);

            JaProperty.getPropertyMap().putIfAbsent("ja.alarm.webhook.notify.default", "https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=7ee5dd4d-8bd9-4ba9-9d40-fb829beb1e36");
            JaNotify.setNotifyHandler(new JaQyWxAlarm("notify.default")::alarm);
        } else {
            JaProperty.getPropertyMap().put("dwloadBalanceEnable", false);
//            JaProperty.getPropertyMap().put("spring.rabbitmq.virtual-host", "test-jugg");
        }


        JaProperty.getPropertyMap().put("ja.swagger.basePackage", "com.digiwin");
    }

    @Override
    public int order() {
        return 100;
    }

    public static void main(String[] args) {
        new JaFeiShuAlarm("notify.default").alarm("test ok http");
    }
}
