package com.jugg.agile.biz.digiwin.config.post;

import com.jugg.agile.biz.digiwin.config.env.DwEnvPropertyHandler;
import com.jugg.agile.framework.core.config.JaPostPropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;

import java.util.Set;

/**
 * 私有化部署适配
 * TODO 待定, 是否适配整个智驱, 原因 : 多rds, 多mongo是否配置统一???
 * https://docs.qq.com/sheet/DSk1ZTnBFWUNhRGJD?tab=BB08J2
 * <p>
 * 1.地端中间件部署 所有中间件用一套配置
 * 2.所有配置都会追加到环境变量里面
 *
 * @author chenjian
 * @since 2024年09月02日 09:58:31
 */
public class DwPrivateDeploymentPostPropertyHandler implements JaPostPropertyHandler {

    @Override
    public void addAndCover() {
        if (DwEnvPropertyHandler.getIsLocal()) {
            wrapNacosDiscovery();
            wrapMysql();
            wrapDomain();
        }
    }

    @Override
    public int order() {
        return 10;
    }

    private void wrapNacosDiscovery() {
        JaProperty.getPropertyMap().put("dwdiscoveryServer", System.getenv().get("spring.cloud.nacos.discovery.server-addr"));
    }

    private void wrapMysql() {
        String host = System.getenv().get("custom.datasource.host");
        if (JaStringUtil.isSafeEmpty(host)) {
            return;
        }
        String port = System.getenv().get("custom.datasource.port");

        Set<String> keys = JaProperty.getPropertyMap().keySet();
        keys.forEach(key -> {
            if (key.startsWith("spring.datasource.") && key.endsWith(".url")) {
                String oldJdbcUrl = JaProperty.get(key);
                int i = oldJdbcUrl.indexOf("//") + 2;
                int i1 = oldJdbcUrl.indexOf("?");
                // 47.102.215.110:22698/athena_im
                String substring = oldJdbcUrl.substring(i, i1);
                String database = substring.split("/")[1];
                // jdbc:mysql://digiwincloud-prod-athena.mariadb.database.azure.com/athena_im?serverTimezone=Asia/Shanghai&useUnicode=true&characterEncoding=utf-8&zeroDateTimeBehavior=convertToNull&useSSL=false&allowPublicKeyRetrieval=true
                String jdbcUrl = String.format("jdbc:mariadb://%s:%s/%s?serverTimezone=Asia/Shanghai&useUnicode=true&characterEncoding=utf-8&zeroDateTimeBehavior=convertToNull&useSSL=false&allowPublicKeyRetrieval=true"
                        , host
                        , port
                        , database
                );
                JaProperty.getPropertyMap().put("spring.datasource.driver-class-name", "org.mariadb.jdbc.Driver");
                JaLog.info("wrapMysql : {}={}", key, jdbcUrl);
                JaProperty.getPropertyMap().put(key, jdbcUrl);
            }

        });
    }

    public static void main(String[] args) {
        String oldJdbcUrl = "jdbc:mysql://digiwincloud-prod-athena.mariadb.database.azure.com/athena_im?serverTimezone=Asia/Shanghai&useUnicode=true&characterEncoding=utf-8&zeroDateTimeBehavior=convertToNull&useSSL=false&allowPublicKeyRetrieval=true";
        int i = oldJdbcUrl.indexOf("//") + 2;
        int i1 = oldJdbcUrl.indexOf("?");
        // 47.102.215.110:22698/athena_im
        String substring = oldJdbcUrl.substring(i, i1);
        String database = substring.split("/")[1];
        // jdbc:mysql://digiwincloud-prod-athena.mariadb.database.azure.com/athena_im?serverTimezone=Asia/Shanghai&useUnicode=true&characterEncoding=utf-8&zeroDateTimeBehavior=convertToNull&useSSL=false&allowPublicKeyRetrieval=true
        String jdbcUrl = String.format("jdbc:mariadb://%s:%s/%s?serverTimezone=Asia/Shanghai&useUnicode=true&characterEncoding=utf-8&zeroDateTimeBehavior=convertToNull&useSSL=false&allowPublicKeyRetrieval=true"
                , "host"
                , "port"
                , database
        );

        System.out.println(jdbcUrl);

        // jdbc:mariadb://host:port/athena_im?serverTimezone=Asia/Shanghai&useUnicode=true&characterEncoding=utf-8&zeroDateTimeBehavior=convertToNull&useSSL=false&allowPublicKeyRetrieval=true
        // jdbc:mysql://47.102.215.110:22698/athena_im?serverTimezone=Asia/Shanghai&useUnicode=true&characterEncoding=utf-8&zeroDateTimeBehavior=convertToNull&useSSL=false&allowPublicKeyRetrieval=true

        // ?serverTimezone=Asia/Shanghai&useUnicode=true&characterEncoding=utf-8&zeroDateTimeBehavior=convertToNull&useSSL=false&allowPublicKeyRetrieval=true
        // ?serverTimezone=Asia/Shanghai&useUnicode=true&characterEncoding=utf-8&zeroDateTimeBehavior=convertToNull&useSSL=false&allowPublicKeyRetrieval=true

    }

    private void wrapMongodb() {
        String cluster = System.getenv().get("custom.data.mongodb.cluster");
        if (JaStringUtil.isSafeEmpty(cluster)) {
            return;
        }

        String username = System.getenv().get("spring.data.mongodb.username");
        String password = System.getenv().get("spring.data.mongodb.password");
        // mongodb+srv://<db_username>:<db_password>@<clusterName>.mongodb.net/?retryWrites=true&w=majority
        String mongoUri = String.format("mongodb://%s:%s@%s"
                , username
                , password
                , cluster
        );

        Set<String> keys = JaProperty.getPropertyMap().keySet();
        keys.forEach(key -> {
            if (key.startsWith("spring.data.") && key.contains("mongodb")) {
                if (key.endsWith(".uri")) {
                    JaLog.info("wrapMongodb : {}={}", key, mongoUri);
                    JaProperty.getPropertyMap().put(key, mongoUri);
                }
            }
        });
    }

    private void wrapDomain() {
        String domainLocal = System.getenv().get("custom.domain");
        if (JaStringUtil.isSafeEmpty(domainLocal)) {
            return;
        }

        // https://iam.digiwincloud.com.cn          >       http://iam.project.com
        // https://iam.apps.digiwincloud.com.cn     >       http://iam.project.com
        // https://iam.digiwincloud.com.cn          >       http://iam.athena.127.0.0.1.nip.io


        String domainCNA = "apps.digiwincloud.com.cn";
        String domainCNB = "digiwincloud.com.cn";


        String domainTWA = "apps.digiwincloud.com";
        String domainTWB = "digiwincloud.com";

        String domainYunA = "digiwincloudlocal.com.cn";
        String domainYunB = "digiwincloudlocal.com";

        JaProperty.getPropertyMap().forEach((k, v) -> {
            String value = v.toString();

            String replaceDomain = null;

            if (value.startsWith("https://")) {
                if (value.contains(domainCNA)) {
                    replaceDomain = domainCNA;
                } else if (value.contains(domainCNB)) {
                    replaceDomain = domainCNB;
                } else if (value.contains(domainTWA)) {
                    replaceDomain = domainTWA;
                } else if (value.contains(domainTWB)) {
                    replaceDomain = domainTWB;
                } else if (value.contains(domainYunA)) {
                    replaceDomain = domainYunA;
                } else if (value.contains(domainYunB)) {
                    replaceDomain = domainYunB;
                }

                if (null != replaceDomain) {
                    JaProperty.getPropertyMap().put(k, value.replace("https", "http").replace(replaceDomain, domainLocal));
                }
            }

        });

    }

}
