package com.jugg.agile.biz.digiwin.config.pre;

import com.jugg.agile.biz.digiwin.util.DwNacosUtil;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaPrePropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.processor.JaPropertiesProcessor;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;

import java.util.Map;
import java.util.Properties;

/**
 * 加载 nacos 所需要的配置
 *
 * @author chenjian
 * @since 2024年06月14日 17:42:12
 */
public class DwNacosConfigPropertyHandler implements JaPrePropertyHandler {
    @Override
    public void addAndCover() {
        if (DwNacosUtil.isExistsJaNacosConfigService()) {
            load();
        }
    }

    private void load() {
        try {
            String serverAddr = JaProperty.get("ja.nacos.serverAddr");
            if (JaStringUtil.isSafeEmpty(serverAddr)) {
                Properties properties = JaPropertiesProcessor.readByResources(String.format("nacos/%s.properties", JaEnvProperty.getEnv()));
                if (null != properties) {
                    properties.forEach((o, o2) -> JaProperty.getPropertyMap().put(o.toString(), o2));
                } else {
                    JaLog.warn("DwNacosConfigPropertyHandler load empty");
                }

            }
        } catch (Throwable e) {
            JaLog.error("DwNacosConfigPropertyHandler init error", e);
        }
    }

    @Override
    public int order() {
        return -10;
    }

    public static void main(String[] args) {
        JaEnvProperty.getEntity().setEnv("aliyun-paas");
        DwNacosConfigPropertyHandler jaNacosConfigNameSpacePropertyHandler = new DwNacosConfigPropertyHandler();
        jaNacosConfigNameSpacePropertyHandler.load();
        Map<String, Object> propertyMap = JaProperty.getPropertyMap();
        System.out.println();

    }

}
