package com.jugg.agile.biz.digiwin.config.center;

import com.jugg.agile.biz.digiwin.util.DwNacosUtil;
import com.jugg.agile.framework.core.config.JaCenterPropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigPropertiesProcessor;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigService;

/**
 * dap 相关配置
 *
 * @author gengwei
 * @since 2024/8/7 13:09
 */
public class DwLoadbalancePropertyHandler implements JaCenterPropertyHandler {
    @Override
    public void addAndCover() {
        try {
            JaProperty.getPropertyMap().put("dwhttpClient.loadbalance.mode", "auto");
            JaProperty.getPropertyMap().put("dwloadBalanceEnable", "true");
            if (DwNacosUtil.isExistsJaNacosConfigService()) {
                JaNacosConfigService.loadYaml("loadbalance.yml", JaNacosConfigPropertiesProcessor.getNameSpaceCommon());
            }
        } catch (Throwable e) {
            JaLog.error("loadbalance nacos read error", e);
        }

    }

    @Override
    public int order() {
        return 10;
    }
}
