package com.jugg.agile.biz.digiwin.context.ask;

import com.jugg.agile.framework.core.context.JaMapContextLink;

import java.util.Map;

/**
 * 小Ai到dap系统的json视图上下文标识<br></>
 * TAG:jsonViewKey
 *
 * @author zhuanghq
 * @since 2024年11月11日 14:56:12
 */
public class DapContextLink implements JaMapContextLink<ASKContextEntity> {
    @Override
    public void inherit(Map<String, String> source, ASKContextEntity target) {
        target.setJsonViewKey(source.get(ASKContextEntity.HeaderJsonViewKey));
    }

    @Override
    public void transmit(ASKContextEntity source, Map<String, String> target) {
        transmit(target, ASKContextEntity.HeaderJsonViewKey, source.getJsonViewKey());
    }
}
