package com.jugg.agile.biz.digiwin.config.common;

import com.jugg.agile.framework.core.util.JaStringUtil;

/**
 * 地端配置处理
 *
 * @author chenjian
 * @since 2024年10月23日 10:32:22
 */
public class DwPrivateDeploymentProcessor {

    public static String getMongoUri() {
        String cluster = System.getenv().get("custom.data.mongodb.cluster");
        if (JaStringUtil.isSafeEmpty(cluster)) {
            return null;
        }

        String username = System.getenv().get("spring.data.mongodb.username");
        String password = System.getenv().get("spring.data.mongodb.password");
        // mongodb+srv://<db_username>:<db_password>@<clusterName>.mongodb.net/?retryWrites=true&w=majority
        return String.format("mongodb://%s:%s@%s"
                , username
                , password
                , cluster
        );
    }
}
