package com.jugg.agile.biz.digiwin.config.common.env;

import com.jugg.agile.framework.core.config.JaEnvPropertyHandler;
import com.jugg.agile.framework.core.config.JaSystemProperty;
import com.jugg.agile.framework.core.dapper.log.logback.JaLogback;
import com.jugg.agile.framework.core.dapper.log.logback.JaLogbackFilter;

/**
 * logback
 *
 * @author chenjian
 * @since 2024年08月02日 09:58:31
 */
public class DwJaLogbackEnvPropertyHandler implements JaEnvPropertyHandler {
    @Override
    public void addAndCover() {
        // 屏蔽日志
        JaLogbackFilter.getInfoDenyLoggerNamePreSet().add("com.ctrip.framework.apollo");
        JaLogbackFilter.getInfoDenyLoggerNamePreSet().add("com.digiwin.loadbalance");
        JaLogbackFilter.getInfoDenyLoggerNamePreSet().add("com.alibaba.nacos.naming.push.receiver");

        // lmc上报相关配置
        JaSystemProperty.putByEnv("lmc_log_endpoint", "lmc_log_endpoint", "");
        JaSystemProperty.putByEnv("lmc_log_app", "lmc_log_app", "");


        // 默认的日志配置
        JaSystemProperty.putByEnv(JaLogback.KeyLocation, JaLogback.KeyLocation, "classpath:log/logback/logback-jugg.xml");
        JaSystemProperty.putByEnv("info_maxFileSize", "ja.log.info.maxFileSize", "1GB");
        JaSystemProperty.putByEnv("info_maxHistory", "ja.log.info.maxHistory", "90");
        JaSystemProperty.putByEnv("info_totalSizeCap", "ja.log.info.totalSizeCap", "15GB");

//        JaSystemProperty.putByEnv("error_maxFileSize", "ja.log.error.maxFileSize", "1GB");
//        JaSystemProperty.putByEnv("error_maxHistory", "ja.log.error.maxHistory", "90");
//        JaSystemProperty.putByEnv("error_totalSizeCap", "ja.log.error.totalSizeCap", "5GB");
    }

    @Override
    public int order() {
        return -9;
    }
}
