package com.jugg.agile.biz.digiwin.context.ask;

import com.jugg.agile.framework.core.context.JaMapContextLink;

import java.util.Map;

/**
 * SD数据迁移上下文标识处理<br></>
 * TAG:archiveRouteKey
 *
 * @author zhuanghq
 * @since 2024年07月31日 15:11:12
 */
public class SDContextLink implements JaMapContextLink<ASKContextEntity> {
    @Override
    public void inherit(Map<String, String> source, ASKContextEntity target) {
        target.setArchiveRouteKey(source.get(ASKContextEntity.HeaderArchiveRouteKey));

    }

    @Override
    public void transmit(ASKContextEntity source, Map<String, String> target) {
        transmit(target, ASKContextEntity.HeaderArchiveRouteKey, source.getArchiveRouteKey());
    }
}
