package com.jugg.agile.biz.digiwin.context.ask.language;

import com.jugg.agile.framework.core.context.biz.JaCoreContextEntity;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.spring.boot.util.JaI18nUtil;
import com.jugg.agile.spring.boot.webmvc.context.JaWebContextLink;
import org.springframework.context.i18n.LocaleContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.util.Locale;
import java.util.Map;

/**
 * 多语言上下文适配
 * 国际化需要适配的情况
 * <p>
 * 传递有3种情况：
 * 1、头传递Accept-Language
 * 2、头传递Locale
 * 3、url传递lang
 * <p>
 * 值有2种情况：
 * 1、en-US
 * 2、en_US
 * <p>
 * 使用情况分2种：
 * LocaleContextHolder.getLocale()
 * request.getHeader("Locale")
 * request.getHeader("locale");
 * <p>
 * <p>
 * 再次传递
 * HttpHeaders：locale
 * HttpHeaders：lang
 *
 * @author chenjian
 * @since 2024年11月01日 16:55:26
 */
public class LangContextLink implements JaWebContextLink<JaCoreContextEntity> {
    public static final String headerLangUp = "Lang";
    public static final String headerLang = "lang";


    @Override
    public void inherit(HttpServletRequest source, JaCoreContextEntity target) {
        if (null == JaI18nUtil.LocaleThreadLocal.get()) {
            String lang = source.getParameter(headerLang);
            if (JaStringUtil.isEmpty(lang)) {
                lang = source.getParameter(headerLangUp);
            }
            if (JaStringUtil.isNotEmpty(lang)) {
                lang = lang.replace('_', '-');
                Locale locale = JaI18nUtil.parseLocales(lang);
                JaI18nUtil.LocaleThreadLocal.set(locale);
                LocaleContextHolder.setLocale(locale);
            }
        }
    }

    @Override
    public void transmit(JaCoreContextEntity source, Map<String, String> target) {
        // Do nothing
    }

    @Override
    public int order() {
        return 10;
    }
}
