package com.jugg.agile.biz.digiwin.config.biz;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;

import java.util.Objects;

public class DwBizConfigProcessor {

    /**
     * @param department aask dap middleware
     * @param group      ai sd km
     * @param app        atmc uibot iam
     */
    public static String initDomainConfig(String department, String group, String app) {

        String protocol = JaProperty.get(String.format("ahthena.%s.%s.%s.protocol", department, group, app), "");
        String domain = JaProperty.get(String.format("ahthena.%s.%s.%s.domain", department, group, app), "");
        String contextPath = JaProperty.get(String.format("ahthena.%s.%s.%s.context-path", department, group, app), "");
        String uri = protocol + domain + contextPath;
        String envUri = JaProperty.get(app + ".uri", "");
        JaLog.info("biz common properties {} envUri:{} athenaUri:{} equals:{}", app, envUri, uri, Objects.equals(uri, envUri));
        if (JaStringUtil.isSafeEmpty(uri)) {
            uri = envUri;
        }
        JaLog.info("biz common properties {} {} {} {} {}", app, protocol, domain, contextPath, uri);
        return uri;
    }
}
