package com.jugg.agile.biz.digiwin.context.ask;

import com.jugg.agile.framework.core.context.JaContext;
import com.jugg.agile.framework.core.util.concurrent.JaThreadLocal;

/**
 * 智驱上下文
 *
 * @author chenjian
 * @since 2024年07月30日 14:31:17
 */
public class ASKContext extends JaContext<ASKContextEntity> {
    private static final JaThreadLocal<ASKContextEntity> jaThreadLocal = new JaThreadLocal<>();
    private static final ASKContext instance = new ASKContext();

    public static ASKContext getInstance() {
        return instance;
    }

    @Override
    public ASKContextEntity set(ASKContextEntity context) {
        jaThreadLocal.set(context);
        return context;
    }

    @Override
    public ASKContextEntity get() {
        return jaThreadLocal.get();
    }

    @Override
    public void remove() {
        jaThreadLocal.remove();
    }
}
