package com.jugg.agile.framework.meta.exception;

import lombok.Getter;
import lombok.Setter;

@Setter
@Getter
public class JaBaseException extends RuntimeException {
    private static final long serialVersionUID = -222070921590767864L;
    /**
     * 是否需要告警
     */
    protected boolean alarm = false;
    /**
     * 是否打印堆栈信息
     */
    protected boolean printStack = true;
    /**
     * 异常信息, 日志打印用
     */
    protected String log;

    public JaBaseException() {
    }

    public JaBaseException(Throwable cause) {
        super(cause);
    }

    public JaBaseException(String message, Throwable cause) {
        super(message, cause);
    }

    public JaBaseException(String message) {
        super(message);
    }

    public JaBaseException buildAlarm(boolean alarm) {
        this.alarm = alarm;
        return this;
    }

    public JaBaseException buildPrintStack(boolean printStack) {
        this.printStack = printStack;
        return this;
    }

    public JaBaseException buildLog(String log) {
        this.log = log;
        return this;
    }
}
