package com.jugg.agile.framework.meta.adapter;

import com.jugg.agile.framework.meta.handler.JaI18nHandler;
import com.jugg.agile.framework.meta.handler.JaLocaleHandler;

import java.util.HashSet;
import java.util.Set;

/**
 * 国际化多语言适配层
 *
 * @author chenjian
 * @since 2024年12月25日 10:28:13
 */
public class JaI18nAdapter {

    private JaI18nAdapter() {
    }

    private static final Set<String> basenameSet = new HashSet<>();

    private static JaI18nHandler i18nHandler;
    private static JaLocaleHandler localeHandler;

    public static void setI18nHandler(JaI18nHandler i18nHandler) {
        JaI18nAdapter.i18nHandler = i18nHandler;
    }

    public static void setLocaleHandler(JaLocaleHandler localeHandler) {
        JaI18nAdapter.localeHandler = localeHandler;
    }


    public static String getMessage(String code, Object... args) {
        return i18nHandler.getMessage(code, args);
    }

    public static String getLocale() {
        return localeHandler.getLocale();
    }

    public static Set<String> getBasenameSet() {
        return basenameSet;
    }
}
