package com.jugg.agile.framework.meta.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.io.Serializable;

@Setter
@Getter
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class JaPageReqDTO implements Serializable {
    private static final long serialVersionUID = -2316735520078748496L;

    /**
     * 页码
     */
    @Builder.Default
    @ApiModelProperty(value = "当前页", example = "非必传,不传递后端默认第一页")
    private int pageIndex = 1;

    /**
     * 每页数据大小
     */
    @Builder.Default
    @ApiModelProperty(value = "每页条数", example = "非必传,不传递后端默认每页20条")
    private int pageSize = 20;
}
