/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.framework.web.util;

import com.alibaba.fastjson.JSON;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.io.net.http.meta.JaContentTypeEnum;
import com.jugg.agile.framework.core.util.io.serialize.json.JaJson;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JaServletUtil {
    private static final String[] headersToCheck = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_X_FORWARDED_FOR", "HTTP_X_FORWARDED", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED"};

    private JaServletUtil() {
    }

    public static String getUserAgent(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        return request.getHeader("User-Agent");
    }

    public static void printResponse(HttpServletRequest request, HttpServletResponse response, Object object) {
        ServletOutputStream out = response.getOutputStream();
        response.setContentType(JaContentTypeEnum.Json.getContentType(StandardCharsets.UTF_8));
        try {
            out.write(JSON.toJSONString((Object)object).getBytes());
        }
        catch (Throwable e) {
            out.write(JaJson.toString((Object)String.format("response print error:[%s:%s:%s]", request.getRequestURL(), object.getClass().getSimpleName(), JaMDC.get())).getBytes());
        }
        out.flush();
    }

    public static String getRemoteAddr(HttpServletRequest request) {
        String ip = request.getHeader(headersToCheck[0]);
        if (JaStringUtil.isNotEmpty((String)ip) && !"unKnown".equalsIgnoreCase(ip)) {
            int index = ip.indexOf(",");
            return index != -1 ? ip.substring(0, index) : ip;
        }
        ip = request.getHeader("X-Real-IP");
        if (JaStringUtil.isNotEmpty((String)ip) && !"unKnown".equalsIgnoreCase(ip)) {
            return ip;
        }
        return request.getRemoteAddr();
    }

    public static Map<String, String> getAllHeaders(HttpServletRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String headerValue = request.getHeader(headerName);
            headers.put(headerName, headerValue);
        }
        return headers;
    }
}

