package com.jugg.agile.framework.web.context;

import com.jugg.agile.framework.core.context.JaContextLink;
import com.jugg.agile.framework.core.util.JaStringUtil;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * 基于HTTP协议传输的上下文节点
 *
 * @author chenjian
 * @see JaWebContextChain
 * @since 2023年03月09日 16:59:39
 */
public interface JaWebContextLink<C> extends JaContextLink<HttpServletRequest, Map<String, String>, C> {

    /**
     * 添加请求头
     *
     * @param headers 请求头Map
     * @param key     请求头
     * @param value   请求头值
     */
    default void addHeader(Map<String, String> headers, String key, Object value) {
        if (null != value) {
            String s = value.toString();
            if (JaStringUtil.isNotEmpty(s)) {
                headers.put(key, s);
            }
        }
    }
}
