package com.jugg.agile.framework.web.servlet;

import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import lombok.Getter;
import lombok.Setter;

import java.util.Set;


@Setter
@Getter
public class JaServletConfig {

    private Filter filter;


    @Setter
    @Getter
    public static class Filter {
        private Set<String> passUrls;
    }

    public boolean isPass(String requestURI) {
        if (null == filter) {
            return false;
        }
        if (JaCollectionUtil.isEmpty(filter.passUrls)) {
            return false;
        }
        for (String passUrl : filter.passUrls) {
            if (requestURI.contains(passUrl)) {
                return true;
            }
        }
        return false;
    }
}
