package com.jugg.agile.middleware.apollo;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.core.ConfigConsts;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.processor.JaPropertiesProcessor;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.concurrent.JaThreadPool;
import com.jugg.agile.middleware.apollo.meta.JaApolloConfigEntity;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class JaApolloConfig {


    public static final ConfigChangeListener DefaultListener = changeEvent -> {
        for (String key : changeEvent.changedKeys()) {
            ConfigChange change = changeEvent.getChange(key);
            JaLog.info(String.format("Found change - key: %s, oldValue: %s, newValue: %s, changeType: %s"
                    , change.getPropertyName(), change.getOldValue(), change.getNewValue(), change.getChangeType()));
            switch (change.getChangeType()) {
                case ADDED:
                case MODIFIED:
                    JaProperty.getPropertyMap().put(key, change.getNewValue());
                    break;
                case DELETED:
                    JaProperty.getPropertyMap().remove(key);
                    break;
            }
        }
        JaLog.info("change:{}", JaProperty.getPropertyMap());
    };

    public static Map<String, Object> read(String namespace) {
        Map<String, Object> map = new HashMap<>();
        Config config = JaApolloConfig.getConfig(JaApolloConfig.getConfigEntity(namespace));
        Set<String> names = config.getPropertyNames();
        names.forEach(name -> map.put(name, config.getProperty(name, "")));
        return map;
    }

    /**
     * appId 默认为applicationName
     */
    public static JaApolloConfigEntity getConfigEntity(String namespace) {
        return getConfigEntity(JaEnvProperty.getApplicationName(), namespace);

    }

    public static JaApolloConfigEntity getConfigEntity(String appId, String namespace) {
        String apolloMeta = System.getProperty("ApolloMeta");
        if (JaStringUtil.isEmpty(apolloMeta)) {
            apolloMeta = JaProperty.get("ja.apollo.meta");
            if (JaStringUtil.isEmpty(apolloMeta)) {
                Properties read = JaPropertiesProcessor.readByResources(String.format("apollo/%s.properties", JaEnvProperty.getEnv()));
                assert read != null;
                apolloMeta = read.get("meta").toString();
            }
        }
        return JaApolloConfigEntity.builder()
                .meta(apolloMeta)
                .namespace(namespace)
                .cluster(JaEnvProperty.getVersion())
                .appId(appId)
                .build();

    }

    public static Config getConfig(JaApolloConfigEntity jaApolloConfigEntity) {
        System.setProperty("app.id", jaApolloConfigEntity.getAppId());
        System.setProperty(ConfigConsts.APOLLO_META_KEY, jaApolloConfigEntity.getMeta());
        System.setProperty(ConfigConsts.APOLLO_CLUSTER_KEY, jaApolloConfigEntity.getCluster());
        return ConfigService.getConfig(jaApolloConfigEntity.getNamespace());
    }


    public static void main(String[] args) {
        JaThreadPool.execute(() -> {
            Config config = JaApolloConfig.getConfig(JaApolloConfigEntity.builder()
                    .appId("atmc")
                    .meta("https://configcenter-config-paas.digiwincloud.com.cn")
                    .cluster("2.2.12")
                    .namespace("application-yml.yml")
                    .build());
            config.addChangeListener(changeEvent -> {
                for (String key : changeEvent.changedKeys()) {
                    ConfigChange change = changeEvent.getChange(key);
                    JaLog.info(String.format("Found change - key: %s, oldValue: %s, newValue: %s, changeType: %s"
                            , change.getPropertyName(), change.getOldValue(), change.getNewValue(), change.getChangeType()));
                }
            });
            Set<String> propertyNames = config.getPropertyNames();
            System.out.println();
        });
    }
}
