/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.apollo;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.processor.JaPropertiesProcessor;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.concurrent.JaThreadPool;
import com.jugg.agile.middleware.apollo.meta.JaApolloConfigEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class JaApolloConfig {
    public static final ConfigChangeListener DefaultListener = changeEvent -> {
        for (String key : changeEvent.changedKeys()) {
            ConfigChange change = changeEvent.getChange(key);
            JaLog.info((String)String.format("Found change - key: %s, oldValue: %s, newValue: %s, changeType: %s", change.getPropertyName(), change.getOldValue(), change.getNewValue(), change.getChangeType()), (Object[])new Object[0]);
            switch (change.getChangeType()) {
                case ADDED: 
                case MODIFIED: {
                    JaProperty.getPropertyMap().put(key, change.getNewValue());
                    break;
                }
                case DELETED: {
                    JaProperty.getPropertyMap().remove(key);
                }
            }
        }
        JaLog.info((String)"change:{}", (Object[])new Object[]{JaProperty.getPropertyMap()});
    };

    public static Map<String, Object> read(String namespace) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Config config = JaApolloConfig.getConfig(JaApolloConfig.getConfigEntity(namespace));
        Set names = config.getPropertyNames();
        names.forEach(name -> map.put((String)name, config.getProperty(name, "")));
        return map;
    }

    public static JaApolloConfigEntity getConfigEntity(String namespace) {
        return JaApolloConfig.getConfigEntity(JaEnvProperty.getApplicationName(), namespace);
    }

    public static JaApolloConfigEntity getConfigEntity(String appId, String namespace) {
        String apolloMeta = System.getProperty("ApolloMeta");
        if (JaStringUtil.isEmpty((String)apolloMeta) && JaStringUtil.isEmpty((String)(apolloMeta = JaProperty.get((String)"ja.apollo.meta")))) {
            Properties read = JaPropertiesProcessor.readByResources((String)String.format("apollo/%s.properties", JaEnvProperty.getEnv()));
            assert (read != null);
            apolloMeta = read.get("meta").toString();
        }
        return JaApolloConfigEntity.builder().meta(apolloMeta).namespace(namespace).cluster(JaEnvProperty.getVersion()).appId(appId).build();
    }

    public static Config getConfig(JaApolloConfigEntity jaApolloConfigEntity) {
        System.setProperty("app.id", jaApolloConfigEntity.getAppId());
        System.setProperty("apollo.meta", jaApolloConfigEntity.getMeta());
        System.setProperty("apollo.cluster", jaApolloConfigEntity.getCluster());
        return ConfigService.getConfig((String)jaApolloConfigEntity.getNamespace());
    }

    public static void main(String[] args) {
        JaThreadPool.execute(() -> {
            Config config = JaApolloConfig.getConfig(JaApolloConfigEntity.builder().appId("atmc").meta("https://configcenter-config-paas.digiwincloud.com.cn").cluster("2.2.12").namespace("application-yml.yml").build());
            config.addChangeListener(changeEvent -> {
                for (String key : changeEvent.changedKeys()) {
                    ConfigChange change = changeEvent.getChange(key);
                    JaLog.info((String)String.format("Found change - key: %s, oldValue: %s, newValue: %s, changeType: %s", change.getPropertyName(), change.getOldValue(), change.getNewValue(), change.getChangeType()), (Object[])new Object[0]);
                }
            });
            Set propertyNames = config.getPropertyNames();
            System.out.println();
        });
    }
}

