/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.db.mybatis.page;

import com.jugg.agile.framework.core.util.concurrent.JaThreadPool;
import com.jugg.agile.framework.meta.JaReturn2;
import com.jugg.agile.framework.meta.dto.JaPageReqDTO;
import com.jugg.agile.framework.meta.function.JaFunctionR;
import com.jugg.agile.middleware.db.mybatis.page.JaMybatisPageContext;
import java.util.List;
import java.util.concurrent.Future;

public class JaMybatisPage {
    public static final ThreadLocal<JaMybatisPageContext> PageThreadLocal = new ThreadLocal();

    private JaMybatisPage() {
    }

    public static <T> JaReturn2<Long, List<T>> page(JaPageReqDTO pageReqDTO, JaFunctionR<List<T>> functionR) {
        return JaMybatisPage.page(pageReqDTO.getPageSize(), pageReqDTO.getPageIndex(), functionR);
    }

    public static <T> JaReturn2<Long, List<T>> page(Integer pageSize, Integer pageIndex, JaFunctionR<List<T>> functionR) {
        Future pageFuture = JaThreadPool.submit(() -> {
            PageThreadLocal.set(JaMybatisPageContext.builder().isCount(false).pageSize(pageSize).pageIndex(pageIndex).build());
            try {
                List list = (List)functionR.apply();
                return list;
            }
            finally {
                PageThreadLocal.remove();
            }
        });
        Future countFuture = JaThreadPool.submit(() -> {
            PageThreadLocal.set(JaMybatisPageContext.builder().isCount(true).pageSize(pageSize).pageIndex(pageIndex).build());
            try {
                functionR.apply();
                Long l = PageThreadLocal.get().getCount();
                return l;
            }
            finally {
                PageThreadLocal.remove();
            }
        });
        return new JaReturn2(countFuture.get(), pageFuture.get());
    }
}

