/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.db.jdbc;

import com.jugg.agile.framework.meta.function.JaFunctionTP;
import com.jugg.agile.middleware.db.jdbc.JaJdbcResultSetProcessor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JaJdbcStatementProcessor {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Map<String, Object>> executeQuery(Connection connection, String sql) {
        try (Statement stmt = connection.createStatement();){
            ArrayList<Map<String, Object>> tables = new ArrayList<Map<String, Object>>();
            JaJdbcResultSetProcessor.get(stmt.executeQuery(sql), tables);
            ArrayList<Map<String, Object>> arrayList = tables;
            return arrayList;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void executeQuery(Connection connection, String sql, JaFunctionTP<ResultSet> jaFunctionP) {
        try (Statement stmt = connection.createStatement();){
            jaFunctionP.apply((Object)stmt.executeQuery(sql));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void executeQueryByRow(Connection connection, String sql, JaFunctionTP<ResultSet> jaFunctionP) {
        try (Statement stmt = connection.createStatement();){
            ResultSet resultSet = stmt.executeQuery(sql);
            while (resultSet.next()) {
                jaFunctionP.apply((Object)resultSet);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

