/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.db.datasource.aspect;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.JaPropertyListener;
import com.jugg.agile.framework.core.dapper.alarm.JaAlarm;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.middleware.db.datasource.JaDataSourceFactory;
import com.jugg.agile.middleware.db.datasource.JaDataSourceRoute;
import com.jugg.agile.middleware.db.datasource.meta.JaDataSourceAnnotation;
import com.jugg.agile.middleware.db.transaction.JaTransactionProcessor;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Map;
import javax.sql.DataSource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Aspect
public class JaConnectionAspect {
    private static long timeout;

    @Pointcut(value="execution(* javax.sql.DataSource.getConnection())")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object aroundAdvice(ProceedingJoinPoint pjp) throws Throwable {
        return this.getConnection(pjp);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object getConnection(ProceedingJoinPoint pjp) throws Throwable {
        JaDataSourceAnnotation route = (JaDataSourceAnnotation)JaDataSourceRoute.getRoute().get();
        if (null == route) {
            return pjp.proceed();
        }
        DataSource dataSource = null;
        Map<String, DataSource> dataSourcePool = JaDataSourceFactory.get();
        if (JaCollectionUtil.isNotEmpty(dataSourcePool)) {
            if (route.isSlaver() && (TransactionSynchronizationManager.isActualTransactionActive() || JaTransactionProcessor.isBeginSpringTx())) {
                String master = route.getMaster();
                if (!JaStringUtil.isNotEmpty((String)master)) {
                    JaLog.get().debug("datasource route slave by : master");
                    return pjp.proceed();
                }
                dataSource = dataSourcePool.get(master);
            } else {
                JaLog.get().debug("datasource route by : {}", (Object)route.getName());
                dataSource = dataSourcePool.get(route.getName());
            }
        }
        if (null == dataSource) {
            throw new RuntimeException("switch datasource error, datasource is null : " + route.getName());
        }
        JaLog.get().debug("datasource route by : {}", (Object)route.getName());
        return dataSource.getConnection();
    }

    private void alarm(long start, ProceedingJoinPoint pjp) {
        long end = System.currentTimeMillis() - start;
        JaAlarm.alarmAndLog((end > timeout ? 1 : 0) != 0, () -> {
            Object target = pjp.getTarget();
            String poolName = "";
            if (target instanceof HikariDataSource) {
                poolName = ((HikariDataSource)target).getPoolName();
            }
            return String.format("javax.sql.DataSource.getConnection poolName:%s timeout: %s > %s", poolName + "", end, timeout);
        }, () -> "javax.sql.DataSource.getConnection timeout");
    }

    static {
        JaPropertyListener.addAndRunCommonListener(() -> {
            timeout = JaProperty.getLong((String)"ja.log.dapper.common.timeout.db-conn", (Long)1000L);
        });
    }
}

