package com.jugg.agile.middleware.db.datasource.aspect;

import com.alibaba.fastjson.JSON;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.bytecode.aop.JaAspectUtil;
import com.jugg.agile.middleware.db.datasource.JaDataSourceRoute;
import com.jugg.agile.middleware.db.datasource.meta.JaDataSource;
import com.jugg.agile.middleware.db.datasource.meta.JaDataSourceAnnotation;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

/**
 * 数据源标示切换
 *
 * @author chenjian
 * @since 2023年06月13日 10:18:18
 */
@Aspect
@Order(Ordered.HIGHEST_PRECEDENCE)
public class JaDataSourceAspect {

    @Pointcut("@within(com.jugg.agile.middleware.db.datasource.meta.JaDataSource) "
            + "|| @annotation(com.jugg.agile.middleware.db.datasource.meta.JaDataSource)"
    )
    public void pointcut() {
    }

    @Around("pointcut()")
    public Object aroundAdvice(ProceedingJoinPoint pjp) throws Throwable {
        JaDataSource annotation = JaAspectUtil.getAnnotation(pjp, JaDataSource.class);
        JaDataSourceAnnotation backUp = null;
        if (null != annotation) {
            backUp = JaDataSourceRoute.getRoute().get();
            JaDataSourceAnnotation dataSourceAnnotation = JaDataSourceAnnotation.converter(annotation);
            JaDataSourceRoute.getRoute().set(dataSourceAnnotation);
            JaLog.get().debug("datasource route info : {}", JSON.toJSONString(dataSourceAnnotation));
        }
        try {
            return pjp.proceed();
        } finally {
            if (null != annotation) {
                if (null == backUp) {
                    JaDataSourceRoute.getRoute().remove();
                } else {
                    JaDataSourceRoute.getRoute().set(backUp);
                }

            }
        }

    }
}
