/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.db.datasource.hikari;

import com.jugg.agile.framework.core.meta.function.JaFunctionP;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.middleware.db.datasource.JaDataSourceFactory;
import com.jugg.agile.middleware.db.datasource.config.JaDataSourceConfig;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.metrics.MetricsTrackerFactory;
import com.zaxxer.hikari.metrics.micrometer.MicrometerMetricsTrackerFactory;
import io.micrometer.core.instrument.MeterRegistry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class JaHikariDataSourceProcessor {
    public static HikariDataSource create(String name, JaDataSourceConfig dataSourceConfig) {
        return JaHikariDataSourceProcessor.create(name, dataSourceConfig, null);
    }

    public static HikariDataSource create(String name, JaDataSourceConfig dataSourceConfig, JaFunctionP<HikariConfig> configWrap) {
        MeterRegistry meterRegistry;
        HikariConfig config = new HikariConfig();
        config.setPoolName("HikariPool-" + name);
        if (JaStringUtil.isNotEmpty((String)dataSourceConfig.getDriverClassName())) {
            config.setDriverClassName(dataSourceConfig.getDriverClassName());
        }
        config.setUsername(dataSourceConfig.getUsername());
        config.setPassword(dataSourceConfig.getPassword());
        config.setMaxLifetime(dataSourceConfig.getMaxLifetime());
        config.setIdleTimeout(dataSourceConfig.getIdleTimeout());
        config.setMinimumIdle(dataSourceConfig.getMinIdle());
        config.setMaximumPoolSize(dataSourceConfig.getMaxActive());
        config.setConnectionTimeout((long)dataSourceConfig.getConnectionTimeout());
        config.setRegisterMbeans(dataSourceConfig.getHikariPC().isRegisterMbeans());
        if (dataSourceConfig.getHikariPC().isRegisterMbeans() && null != (meterRegistry = (MeterRegistry)JaSpringBeanUtil.getBean(MeterRegistry.class))) {
            config.setMetricsTrackerFactory((MetricsTrackerFactory)new MicrometerMetricsTrackerFactory(meterRegistry));
        }
        config.setJdbcUrl(JaDataSourceFactory.getJdbcUrl(dataSourceConfig));
        JaDataSourceFactory.getJdbcProperty(dataSourceConfig).forEach((arg_0, arg_1) -> ((HikariConfig)config).addDataSourceProperty(arg_0, arg_1));
        if (null != configWrap) {
            configWrap.apply((Object)config);
        }
        return new HikariDataSource(config);
    }

    public static void main(String[] args) {
        JaDataSourceConfig dataSourceConfig = new JaDataSourceConfig();
        dataSourceConfig.setIp("gcss-gcsm-mysql-bhw-osit.mysql.oppo.test");
        dataSourceConfig.setPort("33066");
        dataSourceConfig.setUsername("gcsm_osit");
        dataSourceConfig.setPassword("Op_tQMTc8J2l8WDp7TTwYTBNFLcaT3q6");
        dataSourceConfig.setDatabase("gcsm_basic_function");
        HikariDataSource dataSource = JaHikariDataSourceProcessor.create("gcsm_basic_function", dataSourceConfig);
        String sql = "select 1";
        try (Connection connection = dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement(sql);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                System.out.println(rs.getObject(1));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        dataSource.close();
    }
}

