/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.db.datasource;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.processor.JaYamlProcessor;
import com.jugg.agile.framework.core.util.JaShutdownHookUtil;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.reflect.JaReflectUtil;
import com.jugg.agile.middleware.db.datasource.config.JaDataSourceConfig;
import com.jugg.agile.middleware.db.datasource.config.JaDataSourcePoolConfig;
import com.jugg.agile.middleware.db.datasource.hikari.JaHikariDataSourceProcessor;
import com.jugg.agile.middleware.db.jdbc.JaJdbcUrlProcessor;
import com.jugg.agile.middleware.db.jdbc.config.JdbcPropertyConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class JaDataSourceFactory {
    private static Map<String, DataSource> dataSourcePool = null;

    public static Map<String, DataSource> get() {
        return dataSourcePool;
    }

    public static synchronized void create() {
        if (null == dataSourcePool) {
            dataSourcePool = new ConcurrentHashMap<String, DataSource>();
        }
        JaDataSourcePoolConfig dataSourcePoolConfig = (JaDataSourcePoolConfig)JaYamlProcessor.getConfig((String)"ja.datasource", JaDataSourcePoolConfig.class);
        dataSourcePoolConfig.getPool().forEach((name, dataSourceConfig) -> {
            if (!dataSourcePool.containsKey(name)) {
                HikariDataSource dataSource = JaHikariDataSourceProcessor.create(name, dataSourceConfig);
                dataSourcePool.put((String)name, (DataSource)dataSource);
                JaShutdownHookUtil.add((String)("DataSource-" + name), () -> ((HikariDataSource)dataSource).close());
            }
        });
    }

    public static String getJdbcUrl(JaDataSourceConfig dataSourceConfig) {
        if (JaStringUtil.isNotEmpty((String)dataSourceConfig.getJdbcUrl())) {
            return dataSourceConfig.getJdbcUrl();
        }
        return JaJdbcUrlProcessor.get(dataSourceConfig.getIp(), dataSourceConfig.getPort(), dataSourceConfig.getDatabase(), dataSourceConfig.getJdbcUrlParam());
    }

    public static Map<String, Object> getJdbcProperty(JaDataSourceConfig dataSourceConfig) {
        JdbcPropertyConfig property = dataSourceConfig.getJdbcProperty();
        List allFields = JaReflectUtil.getAllFields(JdbcPropertyConfig.class);
        HashMap<String, Object> map = new HashMap<String, Object>(allFields.size());
        for (Field field : allFields) {
            field.setAccessible(true);
            map.put(field.getName(), field.get(property));
        }
        return map;
    }

    public static void main(String[] args) {
        Map map = JaProperty.getPropertyMap();
        map.put("ja.datasource.pool.slaver.database", "drp_infrastructure_server");
        map.put("ja.datasource.pool.slaver.ip", "10.79.3.255");
        map.put("ja.datasource.pool.slaver.port", "33066");
        map.put("ja.datasource.pool.slaver.username", "drp_common");
        map.put("ja.datasource.pool.master.database", "drp_infrastructure_server");
        map.put("ja.datasource.pool.master.ip", "10.79.3.255");
        map.put("ja.datasource.pool.master.port", "33066");
        map.put("ja.datasource.pool.master.username", "drp_common");
        JaDataSourcePoolConfig config = (JaDataSourcePoolConfig)JaYamlProcessor.getConfig((String)"ja.datasource", JaDataSourcePoolConfig.class);
        System.out.println();
    }
}

