package com.jugg.agile.middleware.db.jdbc;

import lombok.SneakyThrows;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * jdbc ResultSet 处理器
 *
 * @author chenjian
 * @since 2024年03月31日 20:13:38
 */
public class JaJdbcResultSetProcessor {

    @SneakyThrows
    public static void get(ResultSet rs, List<Map<String, Object>> rowList) {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        while (rs.next()) {
            Map<String, Object> row = new HashMap<>();
            for (int i = 1; i <= columnCount; i++) {
                row.put(metaData.getColumnName(i), rs.getObject(i));
            }
            rowList.add(row);
        }
    }
}
