/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.db.mybatis.generator;

import com.jugg.agile.framework.core.util.JaStringUtil;
import java.util.List;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.config.GeneratedKey;
import org.mybatis.generator.internal.util.StringUtility;

public class JaUseGeneratedKeysPlugin
extends PluginAdapter {
    public boolean validate(List<String> warnings) {
        return true;
    }

    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        XmlElement root = document.getRootElement();
        for (int i = 0; i < root.getElements().size(); ++i) {
            XmlElement element = (XmlElement)root.getElements().get(i);
            if (!"insert".equalsIgnoreCase(element.getName())) continue;
            this.processGeneratedKey(element, introspectedTable);
        }
        return true;
    }

    private void processGeneratedKey(XmlElement element, IntrospectedTable introspectedTable) {
        GeneratedKey gk = introspectedTable.getGeneratedKey();
        if (gk != null && introspectedTable.hasPrimaryKeyColumns()) {
            if ("pre".equals(gk.getRuntimeSqlStatement())) {
                return;
            }
            this.removeSelectKey(element);
            element.addAttribute(new Attribute("useGeneratedKeys", "true"));
            element.addAttribute(new Attribute("keyProperty", JaStringUtil.underscoreToCamelCase((String)gk.getColumn())));
            element.addAttribute(new Attribute("keyColumn", gk.getColumn()));
        }
    }

    private void removeSelectKey(XmlElement element) {
        for (int i = 0; i < element.getElements().size(); ++i) {
            XmlElement xmlElement;
            if (!(element.getElements().get(i) instanceof XmlElement) || !StringUtility.stringHasValue((String)(xmlElement = (XmlElement)element.getElements().get(i)).getName()) || !xmlElement.getName().equals("selectKey")) continue;
            element.getElements().remove(i);
            break;
        }
    }
}

