/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.db.mybatis.generator;

import java.util.Iterator;
import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.VisitableElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;

public class JaBatchInsertPlugin
extends PluginAdapter {
    public boolean validate(List<String> warnings) {
        return true;
    }

    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        this.createBatchInsertSql(document, introspectedTable);
        return true;
    }

    public boolean clientGenerated(Interface interfaze, IntrospectedTable introspectedTable) {
        FullyQualifiedJavaType recordType = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());
        Method m = this.generateBatchInsertMethod(recordType);
        interfaze.addMethod(m);
        interfaze.addImportedType(recordType);
        interfaze.addImportedType(new FullyQualifiedJavaType("java.util.List"));
        return true;
    }

    private Method generateBatchInsertMethod(FullyQualifiedJavaType recordType) {
        Method method = new Method("insertBatch");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setAbstract(true);
        FullyQualifiedJavaType returnType = new FullyQualifiedJavaType("java.lang.Integer");
        method.setReturnType(returnType);
        FullyQualifiedJavaType parameterType = FullyQualifiedJavaType.getNewListInstance();
        parameterType.addTypeArgument(recordType);
        Parameter parameter = new Parameter(parameterType, "records");
        method.addParameter(parameter);
        return method;
    }

    private void createBatchInsertSql(Document document, IntrospectedTable introspectedTable) {
        List columns = introspectedTable.getAllColumns();
        XmlElement insertBatchElement = new XmlElement("insert");
        insertBatchElement.addAttribute(new Attribute("id", "insertBatch"));
        this.context.getCommentGenerator().addComment(insertBatchElement);
        StringBuilder insertClause = new StringBuilder();
        insertClause.append("insert into ").append(introspectedTable.getFullyQualifiedTableNameAtRuntime()).append(" (");
        Iterator iter = columns.iterator();
        while (iter.hasNext()) {
            IntrospectedColumn introspectedColumn = (IntrospectedColumn)iter.next();
            if (introspectedColumn.isIdentity()) continue;
            insertClause.append("\n").append("      ").append(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn));
            if (!iter.hasNext()) continue;
            insertClause.append(", ");
        }
        insertClause.append(')');
        insertBatchElement.addElement((VisitableElement)new TextElement(insertClause.toString()));
        insertBatchElement.addElement((VisitableElement)new TextElement("values"));
        XmlElement foreach = new XmlElement("foreach");
        foreach.addAttribute(new Attribute("collection", "list"));
        foreach.addAttribute(new Attribute("item", "item"));
        foreach.addAttribute(new Attribute("separator", ","));
        StringBuilder valuesClause = new StringBuilder();
        valuesClause.append(" (");
        iter = columns.iterator();
        while (iter.hasNext()) {
            IntrospectedColumn introspectedColumn = (IntrospectedColumn)iter.next();
            if (introspectedColumn.isIdentity()) continue;
            valuesClause.append("\n").append("      ").append("#{item.").append(introspectedColumn.getJavaProperty()).append(",jdbcType=").append(introspectedColumn.getJdbcTypeName()).append("}");
            if (!iter.hasNext()) continue;
            valuesClause.append(", ");
        }
        valuesClause.append(")");
        foreach.addElement((VisitableElement)new TextElement(valuesClause.toString()));
        insertBatchElement.addElement((VisitableElement)foreach);
        document.getRootElement().addElement((VisitableElement)insertBatchElement);
    }
}

