package com.jugg.agile.middleware.db.datasource.config;

import com.jugg.agile.middleware.db.datasource.hikari.JaHikariConfig;
import com.jugg.agile.middleware.db.jdbc.config.JdbcPropertyConfig;
import com.jugg.agile.middleware.db.jdbc.config.JdbcUrlConfig;
import lombok.Getter;
import lombok.Setter;

@Setter
@Getter
public class JaDataSourceConfig {
    private String database;

    private String ip;
    private String port;
    private String username;
    private String password;
    private String jdbcUrl;
    private String driverClassName;
    private int initialSize = 20;
    private int maxActive = 200;
    private int minIdle = 20;
    /**
     * 此属性控制允许连接在池中处于空闲状态的最长时间。仅当定义为小于 minimumIdle 时，此设置才适用 maximumPoolSize 。
     * 一旦池达到 minimumIdle 连接，闲置连接将不会停用。连接是否因空闲而停用受最大变化 +30 秒和平均变化 +15 秒的约束。
     * 在此超时之前，连接永远不会因空闲而停用。值为 0 表示永远不会从池中删除空闲连接。允许的最小值为 10000 毫秒（10 秒）。默认值：600000（10 分钟）
     */
    private long idleTimeout = 25000;
    /**
     * 此属性控制池中连接的最长生存期。正在使用的连接永远不会停用，只有在关闭时才会将其删除。在逐个连接的基础上，应用较小的负衰减以避免池中的质量消光。
     * 我们强烈建议您设置此值，并且它应比任何数据库或基础设施施加的连接时间限制短几秒钟。值为 0 表示没有最大生命周期（无限生命周期），当然要受 idleTimeout 设置限制。
     * 允许的最小值为 30000 毫秒（30 秒）。默认值：1800000（30 分钟）
     */
    private long maxLifetime = 30000;
    private int connectionTimeout = 5000;


    private JaHikariConfig hikariPC = new JaHikariConfig();

    private JdbcPropertyConfig jdbcProperty = new JdbcPropertyConfig();
    private JdbcUrlConfig jdbcUrlParam = new JdbcUrlConfig();

}
