/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.db.mybatis.generator;

import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.middleware.db.jdbc.JaJdbcConnectionProcessor;
import com.jugg.agile.middleware.db.jdbc.JaJdbcUrlProcessor;
import com.jugg.agile.middleware.db.jdbc.mysql.JaMysqlDescProcessor;
import com.jugg.agile.middleware.db.jdbc.mysql.JaMysqlShowProcessor;
import com.jugg.agile.middleware.db.mybatis.generator.JaMybatisGenerator;
import com.jugg.agile.middleware.db.mybatis.generator.JaMybatisGeneratorXmlParams;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.sql.Connection;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class JaMybatisGeneratorXmlDom4j {
    private static final String targetPackage = "targetPackage";
    private static final String targetProject = "targetProject";

    public static void initGeneratorXml(JaMybatisGeneratorXmlParams xmlParams) {
        SAXReader reader = new SAXReader();
        Document doc = reader.read(new File(xmlParams.getXmlPath()));
        Element root = doc.getRootElement();
        Element classPathEntry = root.element("classPathEntry");
        classPathEntry.attribute("location").setValue(JaMybatisGenerator.getMysqlJarPath());
        Element context = root.element("context");
        Element jdbcConnection = context.element("jdbcConnection");
        String userId = xmlParams.getUserId();
        jdbcConnection.attribute("userId").setValue(userId);
        String password = xmlParams.getPassword();
        jdbcConnection.attribute("password").setValue(password);
        String connectionURL = JaJdbcUrlProcessor.getSimple(xmlParams.getIp(), xmlParams.getPort(), xmlParams.getDatabase());
        jdbcConnection.attribute("connectionURL").setValue(connectionURL);
        try (Connection connection = JaJdbcConnectionProcessor.get(connectionURL, userId, password);){
            List<String> tableNameList = JaMysqlShowProcessor.showTables(connection);
            Element javaModelGenerator = context.element("javaModelGenerator");
            javaModelGenerator.attribute(targetPackage).setValue(xmlParams.getPojoPackage());
            javaModelGenerator.attribute(targetProject).setValue(xmlParams.getPojoTargetProject());
            Element sqlMapGenerator = context.element("sqlMapGenerator");
            sqlMapGenerator.attribute(targetPackage).setValue(xmlParams.getMapperXmlPackage());
            sqlMapGenerator.attribute(targetProject).setValue(xmlParams.getMapperXmlTargetProject());
            Element javaClientGenerator = context.element("javaClientGenerator");
            javaClientGenerator.attribute(targetPackage).setValue(xmlParams.getMapperPackage());
            javaClientGenerator.attribute(targetProject).setValue(xmlParams.getMapperTargetProject());
            List tableNodes = context.selectNodes("./table");
            for (Node tableNode : tableNodes) {
                context.remove(tableNode);
            }
            for (String tableName : tableNameList) {
                Element newTableElement = DocumentHelper.createElement((String)"table");
                String toCamelCase = JaStringUtil.upperFirstCase((String)JaStringUtil.underscoreToCamelCase((String)tableName));
                newTableElement.addAttribute("tableName", tableName);
                newTableElement.addAttribute("domainObjectName", toCamelCase + xmlParams.getPojoSuffix());
                newTableElement.addAttribute("mapperName", toCamelCase + xmlParams.getMapperSuffix());
                newTableElement.addAttribute("delimitIdentifiers", "true");
                String autoIncrementColumn = JaMysqlDescProcessor.getAutoIncrementColumn(connection, tableName);
                if (null != autoIncrementColumn) {
                    Element generatedKeyElement = newTableElement.addElement("generatedKey");
                    generatedKeyElement.addAttribute("column", autoIncrementColumn);
                    generatedKeyElement.addAttribute("sqlStatement", "MySql");
                    generatedKeyElement.addAttribute("identity", "true");
                }
                context.add(newTableElement);
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((Writer)new FileWriter(xmlParams.getXmlPath()), format);
            writer.write(doc);
            writer.close();
        }
    }
}

