/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.db.datasource.aspect;

import com.alibaba.fastjson.JSON;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.bytecode.aop.JaAspectUtil;
import com.jugg.agile.middleware.db.datasource.JaDataSourceRoute;
import com.jugg.agile.middleware.db.datasource.meta.JaDataSource;
import com.jugg.agile.middleware.db.datasource.meta.JaDataSourceAnnotation;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=-2147483648)
public class JaDataSourceAspect {
    @Pointcut(value="@within(com.jugg.agile.middleware.db.datasource.meta.JaDataSource) || @annotation(com.jugg.agile.middleware.db.datasource.meta.JaDataSource)")
    public void pointcut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointcut()")
    public Object aroundAdvice(ProceedingJoinPoint pjp) throws Throwable {
        JaDataSource annotation = (JaDataSource)JaAspectUtil.getAnnotation((ProceedingJoinPoint)pjp, JaDataSource.class);
        JaDataSourceAnnotation backUp = null;
        if (null != annotation) {
            backUp = (JaDataSourceAnnotation)JaDataSourceRoute.getRoute().get();
            JaDataSourceAnnotation dataSourceAnnotation = JaDataSourceAnnotation.converter(annotation);
            JaDataSourceRoute.getRoute().set((Object)dataSourceAnnotation);
            JaLog.get().debug("datasource route info : {}", (Object)JSON.toJSONString((Object)dataSourceAnnotation));
        }
        try {
            Object object = pjp.proceed();
            return object;
        }
        finally {
            if (null != annotation) {
                if (null == backUp) {
                    JaDataSourceRoute.getRoute().remove();
                } else {
                    JaDataSourceRoute.getRoute().set((Object)backUp);
                }
            }
        }
    }
}

