package com.jugg.agile.middleware.db.dapper;

import com.jugg.agile.framework.core.dapper.aspect.JaDapperAspectPointcut;
import com.jugg.agile.framework.core.dapper.aspect.JaNodeSpanResolver;
import com.jugg.agile.framework.core.dapper.aspect.JaReqArgsFilter;
import com.jugg.agile.framework.core.dapper.meta.NodeKind;
import com.jugg.agile.framework.core.dapper.meta.NodeSpan;
import org.aopalliance.intercept.MethodInvocation;

//@Component
public class JaNodeSpanDb implements JaNodeSpanResolver, JaReqArgsFilter, JaDapperAspectPointcut {

    private static final String mybatis = ".mapper.";
    private static final String jpa = "infrastructure.repository.jdbc";
    private static final String jpaBase = "data.repository.CrudRepository";
    private static final String mybatisPlus = "com.baomidou";

    @Override
    public NodeSpan getNodeSpan(MethodInvocation invocation) {
        String name = invocation.getMethod().getDeclaringClass().getName();
        if (name.contains(mybatis)
                || name.startsWith(mybatisPlus)
                || name.contains(jpa)
                || name.contains(jpaBase)) {
            return get(NodeKind.Constant.Db);
        }
        return null;
    }

    @Override
    public boolean filter(MethodInvocation invocation, Object requestArg) {
        return requestArg.getClass().getName().startsWith(mybatisPlus);
    }

    @Override
    public String getExpression() {
//        String rootPackage = JaSpringBootUtil.getRootPackage();
        String rootPackage = "";
        String jpa = "execution(* " + rootPackage + "..*.infrastructure.repository.jdbc..*.*(..))";
        String mybatis = "execution(* " + rootPackage + "..*.mapper..*.*(..))";
        return String.format("(%s) || (%s)", jpa, mybatis);
    }
}
