package com.jugg.agile.middleware.db.mybatis.interceptor;

import com.jugg.agile.middleware.db.mybatis.page.JaMybatisPageProcessor;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.stereotype.Component;

import java.sql.Connection;

/**
 * 1.分页插件, 结合DrpAdapter实现并行处理, 提高查询效率
 * <p>
 * 2.自动封装操作人插件
 *
 * @author chenjian
 * @since 2020年06月20日 20:23:23
 */
@Intercepts({
        @Signature(type = StatementHandler.class, method = "prepare", args = {Connection.class, Integer.class})
        , @Signature(type = Executor.class, method = "query", args = {MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})
        , @Signature(type = Executor.class, method = "update", args = {MappedStatement.class, Object.class})
})
@Component
public class JaMybatisInterceptor implements Interceptor {

    @Override
    @SuppressWarnings("all")
    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();

        Object target = invocation.getTarget();

        Object parameter = null;

        // 只支持StatementType.PREPARED
        if (target instanceof StatementHandler) {
            Object delegate = SystemMetaObject.forObject(target).getValue("delegate");

            BoundSql boundSql = (BoundSql) SystemMetaObject.forObject(delegate).getValue("boundSql");
            MappedStatement mappedStatement = (MappedStatement) SystemMetaObject.forObject(delegate).getValue("mappedStatement");
            if (SqlCommandType.SELECT == mappedStatement.getSqlCommandType()) {
                parameter = boundSql.getParameterObject();
                JaMybatisPageProcessor.executePage(boundSql);
            }
        } else {
            parameter = args[1];
            if (target instanceof Executor && args.length == 2) {
                MappedStatement mappedStatement = (MappedStatement) args[0];
                SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
                if (SqlCommandType.INSERT == sqlCommandType || SqlCommandType.UPDATE == sqlCommandType) {
//                    ExecuteUpdateUtil.executeUpdate(parameter, sqlCommandType, mappedStatement.getId());
                }
            } else {
                JaMybatisPageProcessor.executePage((BoundSql) args[5]);
            }
        }
        return invocation.proceed();
    }
}
