/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.db.mybatis.page;

import com.jugg.agile.middleware.db.mybatis.page.JaMybatisPage;
import com.jugg.agile.middleware.db.mybatis.page.JaMybatisPageContext;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collections;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.reflection.SystemMetaObject;

public class JaMybatisPageProcessor {
    private JaMybatisPageProcessor() {
    }

    public static Object getPageCount(Invocation invocation) {
        Statement stmt = (Statement)invocation.getArgs()[0];
        ResultSet rs = stmt.getResultSet();
        rs.next();
        JaMybatisPage.PageThreadLocal.get().setCount(rs.getLong(1));
        return Collections.emptyList();
    }

    public static boolean executePageCount() {
        JaMybatisPageContext jaMybatisPageContext = JaMybatisPage.PageThreadLocal.get();
        return null != jaMybatisPageContext && jaMybatisPageContext.getIsCount() != false;
    }

    public static void executePage(BoundSql boundSql) {
        JaMybatisPageContext jaMybatisPageContext = JaMybatisPage.PageThreadLocal.get();
        if (null != jaMybatisPageContext) {
            String sql = boundSql.getSql();
            sql = Boolean.TRUE.equals(jaMybatisPageContext.getIsCount()) ? JaMybatisPageProcessor.wrapCountSql(sql) : JaMybatisPageProcessor.wrapPageSql(sql, jaMybatisPageContext.getPageSize(), jaMybatisPageContext.getPageIndex());
            SystemMetaObject.forObject((Object)boundSql).setValue("sql", (Object)sql);
        }
    }

    private static String wrapPageSql(String sql, Integer pageSize, Integer pageIndex) {
        if (sql.contains("union")) {
            sql = String.format("select * from (%s) t", sql);
        }
        return sql + " limit " + (pageIndex - 1) * pageSize + ", " + pageSize;
    }

    private static String wrapCountSql(String sql) {
        String toLowerCaseFromSql;
        String toLowerCaseSql = sql.toLowerCase();
        if (toLowerCaseSql.contains("union") || toLowerCaseSql.contains("distinct")) {
            return String.format("select count(1) count from (%s) t", sql);
        }
        int from = toLowerCaseSql.indexOf("from");
        if (toLowerCaseSql.lastIndexOf("from") != from) {
            return String.format("select count(1) count from (%s) t", sql);
        }
        int orderBy = toLowerCaseSql.lastIndexOf("order by");
        boolean orderFlag = orderBy > -1 && orderBy > from;
        String fromSql = orderFlag ? sql.substring(from, orderBy) : sql.substring(from);
        String string = toLowerCaseFromSql = orderFlag ? toLowerCaseSql.substring(from, orderBy) : toLowerCaseSql.substring(from);
        if (toLowerCaseFromSql.contains("group by")) {
            return String.format("select count(1) count from (select 1 %s) t", fromSql);
        }
        return "select count(1) count " + fromSql;
    }
}

