/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.middleware.db.datasource;

import com.jugg.agile.framework.core.util.JaThrowableUtil;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.middleware.db.datasource.JaDataSourceFactory;
import com.jugg.agile.middleware.db.datasource.aspect.JaConnectionAspect;
import com.jugg.agile.middleware.db.datasource.aspect.JaDataSourceAspect;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"ja.datasource.enabled"}, havingValue="true")
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
public class JaDataSourceConfiguration
implements InitializingBean {
    @Bean
    public DataSource dataSource() {
        DataSource dataSource;
        JaDataSourceFactory.create();
        Map<String, DataSource> dataSourceMap = JaDataSourceFactory.get();
        if (JaCollectionUtil.isEmpty(dataSourceMap)) {
            JaThrowableUtil.throwRunLog((String)"dataSourceMap is empty", (Object[])new Object[0]);
        }
        if (null == (dataSource = dataSourceMap.get("default"))) {
            dataSource = dataSourceMap.entrySet().iterator().next().getValue();
        }
        return dataSource;
    }

    @Bean
    public JaDataSourceAspect dataSourceAspect() {
        return new JaDataSourceAspect();
    }

    @Bean
    public JaConnectionAspect connectionAspect() {
        return new JaConnectionAspect();
    }

    public void afterPropertiesSet() {
        if (null == JaDataSourceFactory.get()) {
            JaDataSourceFactory.create();
        }
    }
}

