package com.jugg.agile.middleware.db.datasource.hikari;

import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.middleware.db.datasource.JaDataSourceFactory;
import com.jugg.agile.middleware.db.datasource.config.JaDataSourceConfig;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import lombok.SneakyThrows;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class JaHikariDataSourceProcessor {

    @SneakyThrows
    public static HikariDataSource create(String name, JaDataSourceConfig dataSourceConfig) {
        HikariConfig config = new HikariConfig();
        config.setPoolName("HikariPool-" + name);
        if (JaStringUtil.isNotEmpty(dataSourceConfig.getDriverClassName())) {
            config.setDriverClassName(dataSourceConfig.getDriverClassName());
        }
        config.setUsername(dataSourceConfig.getUsername());
        config.setPassword(dataSourceConfig.getPassword());
        config.setMaxLifetime(dataSourceConfig.getMaxLifetime());
        config.setIdleTimeout(dataSourceConfig.getIdleTimeout());
        config.setMinimumIdle(dataSourceConfig.getMinIdle());
        config.setMaximumPoolSize(dataSourceConfig.getMaxActive());
        config.setRegisterMbeans(dataSourceConfig.getHikariPC().isRegisterMbeans());
        config.setJdbcUrl(JaDataSourceFactory.getJdbcUrl(dataSourceConfig));
        JaDataSourceFactory.getJdbcProperty(dataSourceConfig).forEach(config::addDataSourceProperty);
        return new HikariDataSource(config);
    }

    public static void main(String[] args) {
        JaDataSourceConfig dataSourceConfig = new JaDataSourceConfig();
        dataSourceConfig.setIp("gcss-gcsm-mysql-bhw-osit.mysql.oppo.test");
        dataSourceConfig.setPort("33066");
//        dataSourceConfig.setJdbcUrl("jdbc:mysql://gcss-gcsm-mysql-bhw-osit.mysql.oppo.test:33066/gcsm_basic_function?useSSL=false&characterEncoding=UTF-8&rewriteBatchedStatements=true&allowMultiQueries=true&connectionTimeZone=UTC&forceConnectionTimeZoneToSession=true");
        dataSourceConfig.setUsername("gcsm_osit");
        dataSourceConfig.setPassword("Op_tQMTc8J2l8WDp7TTwYTBNFLcaT3q6");
        dataSourceConfig.setDatabase("gcsm_basic_function");
        HikariDataSource dataSource = create("gcsm_basic_function", dataSourceConfig);
        String sql = "select 1";
        try (Connection connection = dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement(sql);
             ResultSet rs = stmt.executeQuery();) {
            while (rs.next()) {
                System.out.println(rs.getObject(1));
            }
        } catch (Throwable e) {
            e.printStackTrace();
        }
        dataSource.close();
    }
}
