package com.jugg.agile.middleware.db.datasource.meta;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target({ElementType.TYPE, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface JaDataSource {

    /**
     * 数据源名, 列子 : slaver or master or clickhouseOrder
     */
    String value();

    /**
     * 是否是只读数据源, 当前存在写或者有事务时, 则不会切换
     * <p>
     * 同一个查询方法, 只会在无事务方法内切换
     * <p>
     * 应对使用从库查询场景
     */
    boolean isSlaver() default false;

    /**
     * isSlaver = true 且 触发了写或者有事务, 则走指定主库
     * <p>
     * 不指定则取默认数据源
     */
    String master() default "";
}
